/*
 * Decompiled with CFR 0.152.
 */
package com.mangomilk.design_decor.blocks.horizontal_tanks;

import com.mangomilk.design_decor.blocks.horizontal_tanks.HorizontalFluidTankBlock;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.LangBuilder;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class HorizontalFluidTankBlockEntity
extends SmartBlockEntity
implements IMultiBlockEntityContainer.Fluid,
IHaveGoggleInformation {
    protected LazyOptional<IFluidHandler> fluidCapability;
    SmartFluidTankBehaviour fluidInventory;
    protected BlockPos controller;
    protected BlockPos lastKnownPos;
    protected boolean updateConnectivity;
    protected int radius = 1;
    protected int length = 1;
    protected Direction.Axis axis;

    public HorizontalFluidTankBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.fluidInventory = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.INPUT, (SmartBlockEntity)this, 1, FluidTankBlockEntity.getCapacityMultiplier(), true).forbidExtraction();
        behaviours.add((BlockEntityBehaviour)this.fluidInventory);
        this.fluidCapability = LazyOptional.of(() -> {
            LazyOptional inputCap = this.fluidInventory.getCapability();
            return new CombinedTankWrapper(new IFluidHandler[]{(IFluidHandler)inputCap.orElse(null)});
        });
    }

    protected void updateConnectivity() {
        this.updateConnectivity = false;
        if (this.f_58857_.m_5776_()) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        ConnectivityHandler.formMulti((BlockEntity)this);
    }

    public void tick() {
        super.tick();
        if (this.fluidInventory.getPrimaryHandler().getFluidAmount() > this.fluidInventory.getPrimaryHandler().getCapacity()) {
            this.fluidInventory.getPrimaryHandler().setFluid(new FluidStack(this.fluidInventory.getPrimaryHandler().getFluid(), this.fluidInventory.getPrimaryHandler().getCapacity()));
        }
        if (this.isController()) {
            this.setTankSize(1, (int)(Math.pow(this.getHeight(), 2.0) * (double)this.getWidth()));
        }
        if (this.lastKnownPos == null) {
            this.lastKnownPos = this.m_58899_();
        } else if (!this.lastKnownPos.equals((Object)this.f_58858_) && this.f_58858_ != null) {
            this.onPositionChanged();
            return;
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
    }

    public int getCapacity() {
        return (int)(8000.0 * (Math.pow(this.getHeight(), 2.0) * (double)this.getWidth()));
    }

    public BlockPos getLastKnownPos() {
        return this.lastKnownPos;
    }

    public boolean isController() {
        return this.controller == null || this.f_58858_.m_123341_() == this.controller.m_123341_() && this.f_58858_.m_123342_() == this.controller.m_123342_() && this.f_58858_.m_123343_() == this.controller.m_123343_();
    }

    private void onPositionChanged() {
        this.removeController(true);
        this.lastKnownPos = this.f_58858_;
    }

    public HorizontalFluidTankBlockEntity getControllerBE() {
        if (this.isController()) {
            return this;
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.controller);
        if (blockEntity instanceof HorizontalFluidTankBlockEntity) {
            return (HorizontalFluidTankBlockEntity)blockEntity;
        }
        return null;
    }

    public void removeController(boolean keepContents) {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        this.updateConnectivity = true;
        this.controller = null;
        this.radius = 1;
        this.length = 1;
        BlockState state = this.m_58900_();
        if (HorizontalFluidTankBlock.isBarrel(state)) {
            state = (BlockState)state.m_61124_((Property)HorizontalFluidTankBlock.LARGE, (Comparable)Boolean.valueOf(false));
            this.m_58904_().m_7731_(this.f_58858_, state, 22);
        }
        this.fluidCapability.invalidate();
        this.m_6596_();
        this.sendData();
    }

    public void setController(BlockPos controller) {
        if (this.f_58857_.f_46443_ && !this.isVirtual()) {
            return;
        }
        if (controller.equals((Object)this.controller)) {
            return;
        }
        this.controller = controller;
        this.fluidCapability.invalidate();
        this.m_6596_();
        this.sendData();
    }

    public BlockPos getController() {
        return this.isController() ? this.f_58858_ : this.controller;
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        boolean changeOfController;
        super.read(compound, clientPacket);
        BlockPos controllerBefore = this.controller;
        int prevSize = this.radius;
        int prevLength = this.length;
        this.updateConnectivity = compound.m_128441_("Uninitialized");
        this.controller = null;
        this.lastKnownPos = null;
        if (compound.m_128441_("LastKnownPos")) {
            this.lastKnownPos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("LastKnownPos"));
        }
        if (compound.m_128441_("Controller")) {
            this.controller = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("Controller"));
        }
        if (this.isController()) {
            this.radius = compound.m_128451_("Size");
            this.length = compound.m_128451_("Length");
        }
        this.fluidInventory.getPrimaryHandler().readFromNBT(compound.m_128469_("inputContent"));
        boolean bl = controllerBefore == null ? this.controller != null : (changeOfController = !controllerBefore.equals((Object)this.controller));
        if (this.m_58898_() && (changeOfController || prevSize != this.radius || prevLength != this.length)) {
            this.f_58857_.m_6550_(this.m_58899_(), Blocks.f_50016_.m_49966_(), this.m_58900_());
        }
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        if (this.updateConnectivity) {
            compound.m_128379_("Uninitialized", true);
        }
        if (this.lastKnownPos != null) {
            compound.m_128365_("LastKnownPos", (Tag)NbtUtils.m_129224_((BlockPos)this.lastKnownPos));
        }
        if (!this.isController()) {
            compound.m_128365_("Controller", (Tag)NbtUtils.m_129224_((BlockPos)this.controller));
        }
        if (this.isController()) {
            compound.m_128405_("Size", this.radius);
            compound.m_128405_("Length", this.length);
        }
        compound.m_128365_("inputContent", (Tag)this.fluidInventory.getPrimaryHandler().writeToNBT(new CompoundTag()));
        super.write(compound, clientPacket);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            this.initCapability();
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    private void initCapability() {
        if (!this.isController()) {
            HorizontalFluidTankBlockEntity controllerBE = this.getControllerBE();
            if (controllerBE == null) {
                return;
            }
            controllerBE.initCapability();
            this.fluidCapability = controllerBE.fluidCapability;
            return;
        }
        this.fluidCapability = LazyOptional.of(() -> {
            LazyOptional inputCap = this.fluidInventory.getCapability();
            return new CombinedTankWrapper(new IFluidHandler[]{(IFluidHandler)inputCap.orElse(null)});
        });
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        HorizontalFluidTankBlockEntity controllerBE = this.getControllerBE();
        LazyOptional handler = this.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
        Optional resolve = handler.resolve();
        if (!resolve.isPresent()) {
            return false;
        }
        IFluidHandler tank = (IFluidHandler)resolve.get();
        if (tank.getTanks() == 0) {
            return false;
        }
        LangBuilder mb = Lang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        boolean isEmpty = true;
        for (int i = 0; i < tank.getTanks(); ++i) {
            FluidStack fluidStack = tank.getFluidInTank(i);
            if (fluidStack.isEmpty()) continue;
            Lang.fluidName((FluidStack)fluidStack).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
            Lang.builder().add(Lang.number((double)fluidStack.getAmount()).add(mb).style(ChatFormatting.DARK_GREEN)).text(ChatFormatting.GRAY, " / ").add(Lang.number((double)tank.getTankCapacity(i)).add(mb).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
            isEmpty = false;
        }
        if (tank.getTanks() > 1) {
            if (isEmpty) {
                tooltip.remove(tooltip.size() - 1);
            }
            return true;
        }
        if (!isEmpty) {
            return true;
        }
        Lang.translate((String)"gui.goggles.fluid_container.capacity", (Object[])new Object[0]).add(Lang.number((double)tank.getTankCapacity(0)).add(mb).style(ChatFormatting.DARK_GREEN)).style(ChatFormatting.DARK_GRAY).forGoggles(tooltip, 1);
        return true;
    }

    public static int getMaxLength(int radius) {
        return radius * 3;
    }

    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    public void notifyMultiUpdated() {
        BlockState state = this.m_58900_();
        if (HorizontalFluidTankBlock.isBarrel(state)) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)state.m_61124_((Property)HorizontalFluidTankBlock.LARGE, (Comparable)Boolean.valueOf(this.radius > 2)), 6);
        }
        this.fluidCapability.invalidate();
        this.m_6596_();
    }

    public Direction.Axis getMainConnectionAxis() {
        return this.getMainAxisOf((BlockEntity)this);
    }

    public int getMaxLength(Direction.Axis longAxis, int width) {
        if (longAxis == Direction.Axis.Y) {
            return this.getMaxWidth();
        }
        return HorizontalFluidTankBlockEntity.getMaxLength(width);
    }

    public void setTankSize(int tank, int blocks) {
        this.applyFluidTankSize(blocks);
    }

    public void applyFluidTankSize(int blocks) {
        this.fluidInventory.getPrimaryHandler().setCapacity(blocks * FluidTankBlockEntity.getCapacityMultiplier());
    }

    public int getMaxWidth() {
        return 3;
    }

    public int getHeight() {
        return this.length;
    }

    public int getWidth() {
        return this.radius;
    }

    public int getLength() {
        return this.length;
    }

    public void setHeight(int height) {
        this.length = height;
    }

    public void setWidth(int width) {
        this.radius = width;
    }
}

