/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.evenmoreinstruments.util;

import com.cstav.evenmoreinstruments.EMIMain;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class CommonUtil {
    public static CompoundTag getOrCreateElementTag(ItemStack item, String key) {
        return CommonUtil.getOrCreateElementTag(EMIMain.modTag(item), key);
    }

    public static CompoundTag getOrCreateElementTag(CompoundTag parent, String key) {
        return CommonUtil.getOrCreateTag(parent, key, 10, CompoundTag::new);
    }

    public static ListTag getOrCreateListTag(CompoundTag parent, String key) {
        return CommonUtil.getOrCreateTag(parent, key, 9, ListTag::new);
    }

    public static <T extends Tag> T getOrCreateTag(ItemStack item, String key, int type, Supplier<T> orElse) {
        return CommonUtil.getOrCreateTag(EMIMain.modTag(item), key, type, orElse);
    }

    public static <T extends Tag> T getOrCreateTag(CompoundTag parent, String key, int type, Supplier<T> orElse) {
        if (parent.m_128425_(key, type)) {
            return (T)parent.m_128423_(key);
        }
        Tag tag = (Tag)orElse.get();
        parent.m_128365_(key, tag);
        return (T)tag;
    }

    public static InteractionHand getOffhand(InteractionHand hand) {
        return hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
    }

    public static CompoundTag deepConvertCompound(CompoundTag compound, Map<String, String> oldToNewMapper) {
        CompoundTag result = new CompoundTag();
        compound.m_128431_().forEach(key -> {
            String newKey = (String)oldToNewMapper.get(key);
            if (newKey == null) {
                return;
            }
            if (compound.m_128425_(key, 10)) {
                result.m_128365_(newKey, (Tag)CommonUtil.deepConvertCompound(compound.m_128469_(key), oldToNewMapper));
            } else if (compound.m_128425_(key, 9)) {
                result.m_128365_(newKey, (Tag)CommonUtil.deepConvertList((ListTag)compound.m_128423_(key), oldToNewMapper));
            } else {
                result.m_128365_(newKey, compound.m_128423_(key).m_6426_());
            }
        });
        return result;
    }

    public static ListTag deepConvertList(ListTag list, Map<String, String> oldToNewMapper) {
        ListTag result = new ListTag();
        list.forEach(tag -> {
            if (tag instanceof ListTag) {
                ListTag lt = (ListTag)tag;
                result.add((Object)CommonUtil.deepConvertList(lt, oldToNewMapper));
            } else if (tag instanceof CompoundTag) {
                CompoundTag ct = (CompoundTag)tag;
                result.add((Object)CommonUtil.deepConvertCompound(ct, oldToNewMapper));
            } else {
                result.add((Object)tag.m_6426_());
            }
        });
        return result;
    }

    public static void moveTags(CompoundTag source, CompoundTag dest, String key) {
        Tag value = source.m_128423_(key);
        dest.m_128365_(key, value);
        source.m_128473_(key);
    }

    public static void loadClasses(Class<?>[] classes) {
        for (Class<?> loadMe : classes) {
            try {
                Class.forName(loadMe.getName());
            }
            catch (ClassNotFoundException e) {
                EMIMain.LOGGER.error("Failed to load class " + loadMe.getSimpleName() + ": class not found", (Throwable)e);
            }
        }
    }

    public static Optional<ItemStack> getItemInBothHands(Player player, Item item) {
        ItemStack result = player.m_21120_(InteractionHand.MAIN_HAND);
        if (result.m_150930_(item)) {
            return Optional.of(result);
        }
        result = player.m_21120_(InteractionHand.MAIN_HAND);
        if (result.m_150930_(item)) {
            return Optional.of(result);
        }
        return Optional.empty();
    }
}

