/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.evenmoreinstruments.networking.packet;

import com.cstav.genshinstrument.networking.IModPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class LooperPlayStatePacket
implements IModPacket {
    public static final NetworkDirection NETWORK_DIRECTION = NetworkDirection.PLAY_TO_CLIENT;
    private final boolean isPlaying;
    private final BlockPos blockPos;

    public LooperPlayStatePacket(boolean isPlaying, BlockPos blockPos) {
        this.isPlaying = isPlaying;
        this.blockPos = blockPos;
    }

    public LooperPlayStatePacket(FriendlyByteBuf buf) {
        this.isPlaying = buf.readBoolean();
        this.blockPos = buf.m_130135_();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBoolean(this.isPlaying);
        buf.m_130064_(this.blockPos);
    }

    public void handle(NetworkEvent.Context context) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            Level level = Minecraft.m_91087_().f_91074_.m_9236_();
            for (LivingEntity livingentity : level.m_45976_(LivingEntity.class, new AABB(this.blockPos).m_82400_(3.0))) {
                livingentity.m_6818_(this.blockPos, this.isPlaying);
            }
        });
    }
}

