/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.evenmoreinstruments.networking.packet;

import com.cstav.evenmoreinstruments.EMIMain;
import com.cstav.evenmoreinstruments.block.blockentity.LooperBlockEntity;
import com.cstav.evenmoreinstruments.networking.EMIPacketHandler;
import com.cstav.evenmoreinstruments.networking.packet.LooperUnplayablePacket;
import com.cstav.evenmoreinstruments.networking.packet.SyncModTagPacket;
import com.cstav.evenmoreinstruments.util.LooperUtil;
import com.cstav.genshinstrument.capability.instrumentOpen.InstrumentOpenProvider;
import com.cstav.genshinstrument.networking.IModPacket;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class DoesLooperExistPacket
implements IModPacket {
    public static final NetworkDirection NETWORK_DIRECTION = NetworkDirection.PLAY_TO_SERVER;
    public static final int MAX_RECORD_DIST = 8;
    final Optional<InteractionHand> hand;

    public DoesLooperExistPacket(InteractionHand hand) {
        this.hand = Optional.of(hand);
    }

    public DoesLooperExistPacket() {
        this.hand = Optional.empty();
    }

    public DoesLooperExistPacket(FriendlyByteBuf buf) {
        this.hand = buf.m_236860_(fbb -> (InteractionHand)fbb.m_130066_(InteractionHand.class));
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_236835_(this.hand, FriendlyByteBuf::m_130068_);
    }

    public void handle(NetworkEvent.Context context) {
        LooperBlockEntity looperBE;
        ServerPlayer player = context.getSender();
        ServerLevel level = player.m_9236_();
        if (this.hand.isPresent()) {
            ItemStack instrumentItem = player.m_21120_(this.hand.get());
            looperBE = LooperUtil.getFromItemInstrument((Level)level, instrumentItem);
            if (looperBE != null && !looperBE.m_58899_().m_203195_((Position)player.m_20182_(), 8.0)) {
                looperBE = null;
                LooperUtil.remLooperTag(instrumentItem);
            }
        } else {
            BlockPos instrumentBlockPos = InstrumentOpenProvider.getBlockPos((Player)player);
            BlockEntity instrumentBlockEntity = level.m_7702_(instrumentBlockPos);
            looperBE = LooperUtil.getFromBlockInstrument((Level)level, instrumentBlockEntity);
            if (looperBE == null) {
                EMIPacketHandler.sendToClient(new SyncModTagPacket(EMIMain.modTag(instrumentBlockEntity), instrumentBlockPos), player);
            }
        }
        if (looperBE == null) {
            EMIPacketHandler.sendToClient(new LooperUnplayablePacket(), player);
        }
    }
}

