/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.evenmoreinstruments.item;

import com.cstav.evenmoreinstruments.EMIMain;
import com.cstav.evenmoreinstruments.block.LooperBlock;
import com.cstav.evenmoreinstruments.block.blockentity.LooperBlockEntity;
import com.cstav.evenmoreinstruments.block.partial.IDoubleBlock;
import com.cstav.evenmoreinstruments.networking.EMIPacketHandler;
import com.cstav.evenmoreinstruments.networking.packet.SyncModTagPacket;
import com.cstav.evenmoreinstruments.util.CommonUtil;
import com.cstav.evenmoreinstruments.util.LooperUtil;
import com.cstav.genshinstrument.block.partial.AbstractInstrumentBlock;
import com.cstav.genshinstrument.block.partial.InstrumentBlockEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class LooperAdapterItem
extends Item {
    private static final String BLOCK_INSTRUMENT_POS_TAG = "instrument_block";
    private static final String LOOPER_POS_TAG = "looper";

    public LooperAdapterItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        boolean pairSucceed;
        if (pContext.m_43725_().f_46443_) {
            return InteractionResult.CONSUME_PARTIAL;
        }
        BlockPos pos = pContext.m_8083_();
        Block block = pContext.m_43725_().m_8055_(pContext.m_8083_()).m_60734_();
        CompoundTag adapterTag = CommonUtil.getOrCreateElementTag(EMIMain.modTag(pContext.m_43722_()), "looperAdapter");
        Player player = pContext.m_43723_();
        if (block instanceof AbstractInstrumentBlock) {
            pairSucceed = LooperAdapterItem.handleInstrumentBlock(pos, adapterTag, player);
        } else if (block instanceof LooperBlock) {
            pairSucceed = LooperAdapterItem.handleLooperBlock(pos, adapterTag, player);
        } else {
            return InteractionResult.FAIL;
        }
        return pairSucceed ? InteractionResult.SUCCESS : InteractionResult.CONSUME_PARTIAL;
    }

    private static boolean handleInstrumentBlock(BlockPos blockPos, CompoundTag adapterTag, Player player) {
        if (adapterTag.m_128425_(LOOPER_POS_TAG, 10)) {
            return LooperAdapterItem.pairLooperToInstrument(adapterTag, NbtUtils.m_129239_((CompoundTag)adapterTag.m_128469_(LOOPER_POS_TAG)), blockPos, player);
        }
        adapterTag.m_128365_(BLOCK_INSTRUMENT_POS_TAG, (Tag)NbtUtils.m_129224_((BlockPos)blockPos));
        player.m_5661_((Component)Component.m_237115_((String)"item.evenmoreinstruments.looper_adapter.looper.select"), true);
        return true;
    }

    private static boolean handleLooperBlock(BlockPos blockPos, CompoundTag adapterTag, Player player) {
        BlockEntity be = player.m_9236_().m_7702_(blockPos);
        if (!(be instanceof LooperBlockEntity)) {
            return false;
        }
        LooperBlockEntity lbe = (LooperBlockEntity)be;
        if (!lbe.isRecordIn()) {
            player.m_5661_((Component)Component.m_237115_((String)"evenmoreinstruments.looper.no_record").m_130940_(ChatFormatting.RED), true);
            return false;
        }
        if (adapterTag.m_128425_(BLOCK_INSTRUMENT_POS_TAG, 10)) {
            return LooperAdapterItem.pairLooperToInstrument(adapterTag, blockPos, NbtUtils.m_129239_((CompoundTag)adapterTag.m_128469_(BLOCK_INSTRUMENT_POS_TAG)), player);
        }
        if (adapterTag.m_128425_(LOOPER_POS_TAG, 10)) {
            return LooperAdapterItem.syncLoopers(adapterTag, NbtUtils.m_129239_((CompoundTag)adapterTag.m_128469_(LOOPER_POS_TAG)), blockPos, player);
        }
        adapterTag.m_128365_(LOOPER_POS_TAG, (Tag)NbtUtils.m_129224_((BlockPos)blockPos));
        player.m_5661_((Component)Component.m_237115_((String)"item.evenmoreinstruments.looper_adapter.instrument.select").m_130940_(ChatFormatting.GREEN), true);
        return true;
    }

    private static boolean pairLooperToInstrument(CompoundTag adapterTag, InstrumentBlockEntity ibe, LooperBlockEntity lbe, Player player) {
        for (String key : adapterTag.m_128431_()) {
            adapterTag.m_128473_(key);
        }
        return LooperUtil.performPair(lbe, () -> {
            BlockState instrumentBlockState = ibe.m_58900_();
            Block instrumentBlock = instrumentBlockState.m_60734_();
            BlockPos instrumentBlockPos = ibe.m_58899_();
            BlockPos looperBlockPos = lbe.m_58899_();
            BlockPos otherBlockPos = null;
            if (instrumentBlock instanceof IDoubleBlock) {
                IDoubleBlock doubleBlock = (IDoubleBlock)instrumentBlock;
                otherBlockPos = doubleBlock.getOtherBlock(instrumentBlockState, instrumentBlockPos, player.m_9236_());
            }
            LooperUtil.createLooperTag((BlockEntity)ibe, looperBlockPos);
            if (otherBlockPos != null) {
                LooperUtil.createLooperTag(player.m_9236_().m_7702_(otherBlockPos), looperBlockPos);
            }
            ibe.m_6596_();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                EMIPacketHandler.sendToClient(new SyncModTagPacket(EMIMain.modTag((BlockEntity)ibe), instrumentBlockPos), serverPlayer);
                if (otherBlockPos != null) {
                    EMIPacketHandler.sendToClient(new SyncModTagPacket(EMIMain.modTag((BlockEntity)ibe), otherBlockPos), serverPlayer);
                }
            }
        }, player);
    }

    private static boolean pairLooperToInstrument(CompoundTag adapterTag, BlockPos looperPos, BlockPos instrumentPos, Player player) {
        Level level = player.m_9236_();
        BlockEntity lbe = level.m_7702_(looperPos);
        BlockEntity ibe = level.m_7702_(instrumentPos);
        if (!(lbe instanceof LooperBlockEntity) || !(ibe instanceof InstrumentBlockEntity)) {
            return false;
        }
        return LooperAdapterItem.pairLooperToInstrument(adapterTag, (InstrumentBlockEntity)ibe, (LooperBlockEntity)lbe, player);
    }

    private static boolean syncLoopers(CompoundTag adapterTag, LooperBlockEntity lbe1, LooperBlockEntity lbe2, Player player) {
        if (lbe1.m_58899_().equals((Object)lbe2.m_58899_())) {
            return false;
        }
        for (String key : adapterTag.m_128431_()) {
            adapterTag.m_128473_(key);
        }
        if (!lbe1.hasFootage() || !lbe1.hasFootage()) {
            player.m_5661_((Component)Component.m_237115_((String)"evenmoreinstruments.record.no_footage").m_130940_(ChatFormatting.RED), true);
            return true;
        }
        lbe2.setRepeatTick(lbe1.getRepeatTick());
        lbe2.setTicks(lbe1.getTicks());
        player.m_5661_((Component)Component.m_237115_((String)"item.evenmoreinstruments.looper_adapter.instrument.success_pair").m_130940_(ChatFormatting.GREEN), true);
        return true;
    }

    private static boolean syncLoopers(CompoundTag adapterTag, BlockPos looper1Pos, BlockPos looper2Pos, Player player) {
        if (looper2Pos.equals((Object)looper1Pos)) {
            return false;
        }
        Level level = player.m_9236_();
        BlockEntity lbe1 = level.m_7702_(looper1Pos);
        BlockEntity lbe2 = level.m_7702_(looper2Pos);
        if (!(lbe1 instanceof LooperBlockEntity) || !(lbe2 instanceof LooperBlockEntity)) {
            return false;
        }
        return LooperAdapterItem.syncLoopers(adapterTag, (LooperBlockEntity)lbe1, (LooperBlockEntity)lbe2, player);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        if (!Screen.m_96638_()) {
            tooltipComponents.add((Component)Component.m_237115_((String)"item.shift.hint.show").m_130940_(ChatFormatting.YELLOW));
            return;
        }
        tooltipComponents.add((Component)Component.m_237115_((String)"item.shift.hint.hide").m_130940_(ChatFormatting.YELLOW));
        tooltipComponents.add((Component)Component.m_237115_((String)"item.evenmoreinstruments.looper_adapter.instrument.description").m_130940_(ChatFormatting.GRAY));
        tooltipComponents.add((Component)Component.m_237115_((String)"item.evenmoreinstruments.looper_adapter.looper.description").m_130940_(ChatFormatting.GRAY));
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
    }
}

