/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.evenmoreinstruments.item;

import com.cstav.evenmoreinstruments.item.InstrumentAccessoryItem;
import com.cstav.evenmoreinstruments.item.partial.instrument.CreditableInstrumentItem;
import com.cstav.evenmoreinstruments.util.CommonUtil;
import com.cstav.genshinstrument.event.InstrumentPlayedEvent;
import com.cstav.genshinstrument.networking.OpenInstrumentPacketSender;
import com.cstav.genshinstrument.networking.packet.instrument.util.InstrumentPacketUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="evenmoreinstruments", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class AccessoryInstrumentItem
extends CreditableInstrumentItem {
    private final InstrumentAccessoryItem accessory;

    public AccessoryInstrumentItem(OpenInstrumentPacketSender onOpenRequest, InstrumentAccessoryItem accessory, String credit) {
        super(onOpenRequest, credit);
        this.accessory = accessory;
    }

    public AccessoryInstrumentItem(OpenInstrumentPacketSender onOpenRequest, Item.Properties properties, InstrumentAccessoryItem accessory, String credit) {
        super(onOpenRequest, properties, credit);
        this.accessory = accessory;
    }

    public InstrumentAccessoryItem getAccessoryItem() {
        return this.accessory;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack handItem = pPlayer.m_21120_(pUsedHand);
        if (!pPlayer.m_21120_(CommonUtil.getOffhand(pUsedHand)).m_150930_((Item)this.getAccessoryItem())) {
            if (!pLevel.f_46443_) {
                pPlayer.m_5661_((Component)Component.m_237110_((String)"item.evenmoreinstruments.instrument.accessory.not_present", (Object[])new Object[]{this.getAccessoryItem().m_7626_(new ItemStack((ItemLike)this.getAccessoryItem()))}), true);
            }
            return InteractionResultHolder.m_19100_((Object)handItem);
        }
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }

    public void onAccessoryUsed(InstrumentPlayedEvent<?> event, ItemStack accessory) {
        if (!accessory.m_41763_()) {
            return;
        }
        if (event.level().f_46443_) {
            return;
        }
        if (!event.isByPlayer()) {
            return;
        }
        Player player = (Player)((InstrumentPlayedEvent.EntityInfo)event.entityInfo().get()).entity;
        accessory.m_41622_(this.hurtAccessoryBy(event, accessory), (LivingEntity)player, _player -> {
            _player.m_21190_(_player.m_7655_());
            InstrumentPacketUtil.setInstrumentClosed((ServerPlayer)((ServerPlayer)_player));
        });
    }

    public int hurtAccessoryBy(InstrumentPlayedEvent<?> event, ItemStack accessory) {
        return 1;
    }

    @SubscribeEvent
    public static void onInstrumentPlayedEvent(InstrumentPlayedEvent<?> event) {
        if (event.level().f_46443_) {
            return;
        }
        if (!event.isByPlayer()) {
            return;
        }
        InstrumentPlayedEvent.EntityInfo entityInfo = (InstrumentPlayedEvent.EntityInfo)event.entityInfo().get();
        Player player = (Player)entityInfo.entity;
        if (!entityInfo.isItemInstrument()) {
            return;
        }
        Item instruemntItem = player.m_21120_((InteractionHand)entityInfo.hand.get()).m_41720_();
        if (!(instruemntItem instanceof AccessoryInstrumentItem)) {
            return;
        }
        AccessoryInstrumentItem aiItem = (AccessoryInstrumentItem)instruemntItem;
        ItemStack offhandStack = player.m_21120_(CommonUtil.getOffhand((InteractionHand)entityInfo.hand.get()));
        if (!(offhandStack.m_41720_() instanceof InstrumentAccessoryItem)) {
            return;
        }
        if (offhandStack.m_150930_((Item)aiItem.getAccessoryItem())) {
            aiItem.onAccessoryUsed(event, offhandStack);
        }
    }
}

