/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.evenmoreinstruments.block.blockentity;

import com.cstav.evenmoreinstruments.block.LooperBlock;
import com.cstav.evenmoreinstruments.block.ModBlocks;
import com.cstav.evenmoreinstruments.block.blockentity.ModBlockEntities;
import com.cstav.evenmoreinstruments.block.util.WritableNoteType;
import com.cstav.evenmoreinstruments.capability.recording.RecordingCapabilityProvider;
import com.cstav.evenmoreinstruments.gamerule.ModGameRules;
import com.cstav.evenmoreinstruments.item.ModItems;
import com.cstav.evenmoreinstruments.item.emirecord.EMIRecordItem;
import com.cstav.evenmoreinstruments.item.emirecord.RecordRepository;
import com.cstav.evenmoreinstruments.networking.EMIPacketHandler;
import com.cstav.evenmoreinstruments.networking.packet.LooperPlayStatePacket;
import com.cstav.evenmoreinstruments.util.CommonUtil;
import com.cstav.evenmoreinstruments.util.LooperUtil;
import com.cstav.genshinstrument.networking.packet.instrument.NoteSoundMetadata;
import com.cstav.genshinstrument.networking.packet.instrument.util.HeldNoteSoundPacketUtil;
import com.cstav.genshinstrument.networking.packet.instrument.util.HeldSoundPhase;
import com.cstav.genshinstrument.networking.packet.instrument.util.NoteSoundPacketUtil;
import com.cstav.genshinstrument.sound.NoteSound;
import com.cstav.genshinstrument.sound.held.HeldNoteSound;
import com.cstav.genshinstrument.sound.held.InitiatorID;
import com.cstav.genshinstrument.sound.registrar.HeldNoteSoundRegistrar;
import com.cstav.genshinstrument.sound.registrar.NoteSoundRegistrar;
import com.cstav.genshinstrument.util.BiValue;
import com.mojang.logging.LogUtils;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Clearable;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="evenmoreinstruments")
public class LooperBlockEntity
extends BlockEntity
implements Clearable {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String RECORD_TAG = "Record";
    public static final String RECORDING_TAG = "Recording";
    public static final String TICKS_TAG = "Ticks";
    private boolean locked = false;
    private Player lockedBy = null;
    private ItemStack recordIn = ItemStack.f_41583_;
    private CompoundTag channel;
    private final InitiatorID looperInitiatorID;
    protected final HashSet<BiValue<HeldNoteSound, NoteSoundMetadata>> cachedHeldNotes = new HashSet();

    protected void stopAndClearHeldSounds() {
        this.notifyHeldNotesPhase(HeldSoundPhase.RELEASE);
        this.cachedHeldNotes.clear();
    }

    public CompoundTag getChannel() {
        return this.channel;
    }

    private void setChannel(CompoundTag channel) {
        this.channel = channel;
    }

    private void updateChannel() {
        CompoundTag recordData = this.recordIn.m_41784_();
        if (recordData.m_128425_("Channel", 10)) {
            this.channel = recordData.m_128469_("Channel");
        } else if (recordData.m_128425_("BurnedMedia", 8)) {
            this.setChannel(RecordRepository.getRecord(this.getBurnedMediaLoc()).orElse(null));
        }
    }

    protected ResourceLocation getBurnedMediaLoc() {
        return new ResourceLocation(this.recordIn.m_41783_().m_128461_("BurnedMedia"));
    }

    private void updateRecordNBT() {
        this.getPersistentData().m_128365_(RECORD_TAG, (Tag)this.recordIn.m_41739_(new CompoundTag()));
    }

    public boolean hasFootage() {
        CompoundTag channel = this.getChannel();
        return channel != null && channel.m_128425_("Notes", 9) && !channel.m_128437_("Notes", 10).isEmpty();
    }

    public boolean isWritable() {
        return this.getChannel() != null && this.getChannel().m_128471_("Writable");
    }

    public void setWritable(boolean writable) {
        this.getChannel().m_128379_("Writable", writable);
    }

    public boolean isRecordIn() {
        return !this.recordIn.m_41619_();
    }

    protected CompoundTag getRecordData() {
        return this.recordIn.m_41784_();
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.recordIn = ItemStack.m_41712_((CompoundTag)this.getPersistentData().m_128469_(RECORD_TAG));
        this.updateChannel();
    }

    public ItemStack getItem(int pSlot) {
        return this.recordIn;
    }

    public void setItem(int pSlot, ItemStack pStack) {
        Item item = pStack.m_41720_();
        if (!(item instanceof EMIRecordItem)) {
            return;
        }
        EMIRecordItem recordItem = (EMIRecordItem)item;
        this.recordIn = pStack.m_41777_();
        this.recordIn.m_41764_(1);
        recordItem.onInsert(this.recordIn, this);
        this.updateChannel();
        BlockState newState = (BlockState)this.m_58900_().m_61124_((Property)LooperBlock.RECORD_IN, (Comparable)Boolean.valueOf(true));
        if (this.hasFootage()) {
            newState = this.setPlaying(true, newState);
        }
        this.updateRecordNBT();
        this.m_58904_().m_7731_(this.m_58899_(), newState, 3);
        this.m_6596_();
    }

    public ItemStack removeItem(int pSlot, int pAmount) {
        if (!this.isRecordIn() || pAmount <= 0) {
            return ItemStack.f_41583_;
        }
        ItemStack prev = this.recordIn;
        this.recordIn = ItemStack.f_41583_;
        this.m_58904_().m_7731_(this.m_58899_(), (BlockState)this.setPlaying(false, this.m_58900_()).m_61124_((Property)LooperBlock.RECORD_IN, (Comparable)Boolean.valueOf(false)), 3);
        this.getPersistentData().m_128473_(RECORD_TAG);
        this.reset();
        return prev;
    }

    public void m_6211_() {
        this.removeItem(0, 1);
    }

    public int getMaxStackSize() {
        return 1;
    }

    public boolean canPlaceItem(int pIndex, ItemStack pStack) {
        return pStack.m_41720_() instanceof EMIRecordItem && !this.isRecordIn();
    }

    public boolean canTakeItem(Container pTarget, int pIndex, ItemStack pStack) {
        return !this.isRecordIn();
    }

    public LooperBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.LOOPER.get(), pPos, pBlockState);
        this.looperInitiatorID = new InitiatorID("block", String.format("x%sy%sz%s", pPos.m_123341_(), pPos.m_123342_(), pPos.m_123343_()));
        CompoundTag data = this.getPersistentData();
        if (!data.m_128425_(TICKS_TAG, 3)) {
            this.setTicks(0);
        }
    }

    public void setRecording(boolean recording) {
        this.getPersistentData().m_128379_(RECORDING_TAG, recording);
    }

    public void setTicks(int ticks) {
        this.getPersistentData().m_128405_(TICKS_TAG, ticks);
    }

    public int incrementTick() {
        int ticks = this.getTicks();
        int repTick = this.getRepeatTick();
        ticks = repTick != -1 && ticks > repTick ? this.onLooperEnd() : ++ticks;
        this.setTicks(ticks);
        return ticks;
    }

    public int onLooperEnd() {
        if (!((Boolean)this.m_58900_().m_61143_((Property)LooperBlock.LOOPING)).booleanValue()) {
            this.m_58904_().m_46597_(this.m_58899_(), this.setPlaying(false, this.m_58900_()));
        }
        this.stopAndClearHeldSounds();
        return 0;
    }

    public void setRepeatTick(int tick) {
        this.getChannel().m_128405_("RepeatTick", tick);
    }

    public void setLockedBy(Player player) {
        this.lockedBy = player;
    }

    public void lock() {
        this.locked = true;
        this.lockedBy = null;
        this.stopAndClearHeldSounds();
        this.setRepeatTick(this.getTicks());
        this.setRecording(false);
        this.setWritable(false);
        this.setTicks(0);
        this.updateRecordNBT();
        this.m_6596_();
    }

    public void reset() {
        this.locked = false;
        this.lockedBy = null;
        this.setTicks(0);
        this.m_6596_();
    }

    public boolean isLocked() {
        return this.lockedByAnyone() || this.locked;
    }

    public boolean isRecording() {
        return this.getPersistentData().m_128471_(RECORDING_TAG);
    }

    public boolean isAllowedToRecord(Player player) {
        return !this.lockedByAnyone() || this.isLockedBy(player);
    }

    public boolean lockedByAnyone() {
        return this.lockedBy != null;
    }

    public boolean isLockedBy(Player player) {
        return player.equals((Object)this.lockedBy);
    }

    public int getTicks() {
        return this.getPersistentData().m_128451_(TICKS_TAG);
    }

    public int getRepeatTick() {
        CompoundTag channel = this.getChannel();
        if (channel.m_128441_("RepeatTick")) {
            return channel.m_128451_("RepeatTick");
        }
        return -1;
    }

    public BlockState setPlaying(boolean playing, BlockState state) {
        boolean isPlaying = this.hasFootage() && playing;
        BlockState newState = (BlockState)state.m_61124_((Property)LooperBlock.PLAYING, (Comparable)Boolean.valueOf(isPlaying));
        if (!this.m_58904_().f_46443_) {
            this.m_58904_().m_6907_().forEach(player -> EMIPacketHandler.sendToClient(new LooperPlayStatePacket(isPlaying, this.m_58899_()), (ServerPlayer)player));
            this.notifyHeldNotesPhase(playing ? HeldSoundPhase.ATTACK : HeldSoundPhase.RELEASE);
        }
        return newState;
    }

    private void notifyHeldNotesPhase(HeldSoundPhase phase) {
        this.cachedHeldNotes.forEach(bi -> HeldNoteSoundPacketUtil.sendPlayNotePackets((Level)this.f_58857_, (HeldNoteSound)((HeldNoteSound)bi.obj1()), (NoteSoundMetadata)((NoteSoundMetadata)bi.obj2()), (HeldSoundPhase)phase, (InitiatorID)this.looperInitiatorID));
    }

    public void writeNote(NoteSound sound, NoteSoundMetadata soundMeta, int timestamp) {
        if (!this.isWritable()) {
            return;
        }
        CompoundTag noteTag = this.serializeNoteMeta(soundMeta, timestamp);
        noteTag.m_128359_("NoteType", WritableNoteType.REGULAR.name());
        noteTag.m_128405_("SoundIndex", sound.index);
        noteTag.m_128359_("SoundType", sound.baseSoundLocation.toString());
        CommonUtil.getOrCreateListTag(this.getChannel(), "Notes").add((Object)noteTag);
        this.m_6596_();
    }

    public void writeHeldNote(HeldNoteSound sound, HeldSoundPhase phase, NoteSoundMetadata soundMeta, int timestamp) {
        if (!this.isWritable()) {
            return;
        }
        CompoundTag noteTag = this.serializeNoteMeta(soundMeta, timestamp);
        noteTag.m_128359_("NoteType", WritableNoteType.HELD.name());
        noteTag.m_128405_("SoundIndex", sound.index());
        noteTag.m_128359_("SoundType", sound.baseSoundLocation().toString());
        noteTag.m_128359_("HeldPhase", phase.name());
        CommonUtil.getOrCreateListTag(this.getChannel(), "Notes").add((Object)noteTag);
        this.m_6596_();
    }

    protected CompoundTag serializeNoteMeta(NoteSoundMetadata soundMeta, int timestamp) {
        CompoundTag noteTag = new CompoundTag();
        noteTag.m_128405_("Pitch", soundMeta.pitch());
        noteTag.m_128350_("Volume", (float)soundMeta.volume() / 100.0f);
        noteTag.m_128405_("Timestamp", timestamp);
        return noteTag;
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        LooperBlockEntity lbe = LooperUtil.getFromPos(pLevel, pPos);
        boolean isPlaying = (Boolean)lbe.m_58900_().m_61143_((Property)LooperBlock.PLAYING);
        if (!isPlaying && !lbe.isRecording()) {
            return;
        }
        if (lbe.isRecording()) {
            lbe.incrementTick();
        }
        if (!isPlaying) {
            return;
        }
        CompoundTag channel = lbe.getChannel();
        if (channel == null) {
            return;
        }
        int ticks = this.getTicks();
        ResourceLocation instrumentId = new ResourceLocation(channel.m_128461_("InstrumentId"));
        channel.m_128437_("Notes", 10).stream().map(note -> (CompoundTag)note).filter(note -> note.m_128451_("Timestamp") == ticks).forEach(note -> lbe.playNote((CompoundTag)note, instrumentId));
        lbe.incrementTick();
    }

    private void playNote(CompoundTag note, ResourceLocation instrumentId) {
        try {
            String rawNoteType = note.m_128461_("NoteType");
            WritableNoteType noteType = rawNoteType.isEmpty() ? WritableNoteType.REGULAR : WritableNoteType.valueOf(rawNoteType);
            switch (noteType) {
                case REGULAR: {
                    this.playNoteSound(note, instrumentId);
                    break;
                }
                case HELD: {
                    this.playHeldSound(note, instrumentId);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Attempted to play a looper note at {}, but met with an exception", (Object)this.m_58899_(), (Object)e);
        }
    }

    protected void playNoteSound(CompoundTag noteTag, ResourceLocation instrumentId) {
        NoteSoundMetadata meta = this.metaFromNoteTag(noteTag, instrumentId);
        ResourceLocation soundLocation = new ResourceLocation(noteTag.m_128461_("SoundType"));
        int soundIndex = noteTag.m_128451_("SoundIndex");
        NoteSoundPacketUtil.sendPlayNotePackets((Level)this.f_58857_, (NoteSound)NoteSoundRegistrar.getSounds((ResourceLocation)soundLocation)[soundIndex], (NoteSoundMetadata)meta);
        this.triggerEmitNoteParticle(meta.pitch());
    }

    protected void playHeldSound(CompoundTag noteTag, ResourceLocation instrumentId) {
        NoteSoundMetadata meta = this.metaFromNoteTag(noteTag, instrumentId);
        ResourceLocation soundLocation = new ResourceLocation(noteTag.m_128461_("SoundType"));
        int soundIndex = noteTag.m_128451_("SoundIndex");
        HeldNoteSound sound = HeldNoteSoundRegistrar.getSounds((ResourceLocation)soundLocation)[soundIndex];
        HeldSoundPhase phase = HeldSoundPhase.valueOf((String)noteTag.m_128461_("HeldPhase"));
        HeldNoteSoundPacketUtil.sendPlayNotePackets((Level)this.f_58857_, (HeldNoteSound)sound, (NoteSoundMetadata)meta, (HeldSoundPhase)phase, (InitiatorID)this.looperInitiatorID);
        if (phase == HeldSoundPhase.ATTACK) {
            this.cachedHeldNotes.add((BiValue<HeldNoteSound, NoteSoundMetadata>)new BiValue((Object)sound, (Object)meta));
            this.triggerEmitNoteParticle(meta.pitch());
        } else if (phase == HeldSoundPhase.RELEASE) {
            this.cachedHeldNotes.remove(new BiValue((Object)sound, (Object)meta));
        }
    }

    protected NoteSoundMetadata metaFromNoteTag(CompoundTag noteTag, ResourceLocation instrumentId) {
        return new NoteSoundMetadata(this.m_58899_(), noteTag.m_128451_("Pitch"), (int)(noteTag.m_128457_("Volume") * 100.0f), instrumentId, Optional.empty());
    }

    public void triggerEmitNoteParticle(int pitch) {
        this.m_58904_().m_7696_(this.m_58899_(), (Block)ModBlocks.LOOPER.get(), 42, pitch);
    }

    public void popRecord() {
        CompoundTag recordData = this.getRecordData();
        if (this.recordIn.m_150930_((Item)ModItems.RECORD_WRITABLE.get())) {
            if (this.isWritable()) {
                recordData.m_128473_("Notes");
            }
            if (!this.hasFootage()) {
                recordData.m_128473_("Channel");
            }
        }
        this.stopAndClearHeldSounds();
        float offset = 0.7f;
        double offX = (double)(this.m_58904_().f_46441_.m_188501_() * offset) + (double)0.15f;
        double offY = (double)(this.m_58904_().f_46441_.m_188501_() * offset) + (double)0.06f + 0.6;
        double offZ = (double)(this.m_58904_().f_46441_.m_188501_() * offset) + (double)0.15f;
        BlockPos pos = this.m_58899_();
        ItemEntity itementity = new ItemEntity(this.m_58904_(), (double)pos.m_123341_() + offX, (double)pos.m_123342_() + offY, (double)pos.m_123343_() + offZ, this.recordIn);
        itementity.m_32060_();
        this.m_58904_().m_7967_((Entity)itementity);
        this.removeItem(0, 1);
    }

    public void m_7651_() {
        super.m_7651_();
        this.stopAndClearHeldSounds();
    }

    public boolean isCapped(Level level) {
        int cap = level.m_46469_().m_46215_(ModGameRules.RULE_LOOPER_MAX_NOTES);
        return cap >= 0 && this.getChannel().m_128437_("Notes", 10).size() >= cap;
    }

    @SubscribeEvent
    public static void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (!RecordingCapabilityProvider.isRecording(player)) {
            return;
        }
        player.m_9236_().m_141902_(RecordingCapabilityProvider.getLooperPos(player), (BlockEntityType)ModBlockEntities.LOOPER.get()).filter(lbe -> lbe.lockedBy.equals((Object)player)).ifPresent(lbe -> {
            lbe.reset();
            lbe.getPersistentData().m_128379_(RECORDING_TAG, false);
        });
        LooperUtil.setNotRecording(player);
    }
}

