/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.evenmoreinstruments.block;

import com.cstav.evenmoreinstruments.block.blockentity.LooperBlockEntity;
import com.cstav.evenmoreinstruments.block.blockentity.ModBlockEntities;
import com.cstav.evenmoreinstruments.block.util.LooperInteractionRunnable;
import com.cstav.evenmoreinstruments.criteria.ModCriteria;
import com.cstav.evenmoreinstruments.item.emirecord.EMIRecordItem;
import com.cstav.evenmoreinstruments.util.LooperUtil;
import com.cstav.genshinstrument.item.InstrumentItem;
import java.util.List;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class LooperBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty PLAYING = BooleanProperty.m_61465_((String)"playing");
    public static final BooleanProperty RECORD_IN = BooleanProperty.m_61465_((String)"record_in");
    public static final BooleanProperty REDSTONE_TRIGGERED = BooleanProperty.m_61465_((String)"redstone_triggered");
    public static final BooleanProperty LOOPING = BooleanProperty.m_61465_((String)"looping");

    public LooperBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)PLAYING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RECORD_IN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)REDSTONE_TRIGGERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LOOPING, (Comparable)Boolean.valueOf(true)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{PLAYING, FACING, RECORD_IN, REDSTONE_TRIGGERED, LOOPING});
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_());
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        boolean hasFootage = ((LooperBlockEntity)((Object)pLevel.m_141902_(pPos, (BlockEntityType)ModBlockEntities.LOOPER.get()).orElseThrow())).hasFootage();
        if (hasFootage) {
            pLevel.m_46597_(pPos, (BlockState)((BlockState)pState.m_61124_((Property)RECORD_IN, (Comparable)Boolean.valueOf(true))).m_61124_((Property)PLAYING, (Comparable)Boolean.valueOf(true)));
        }
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new LooperBlockEntity(pPos, pState);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return !pLevel.f_46443_ && pBlockEntityType == ModBlockEntities.LOOPER.get() ? (level, pos, state, be) -> ((LooperBlockEntity)be).tick(level, pos, state) : null;
    }

    public static BlockState cyclePlaying(LooperBlockEntity lbe, BlockState state) {
        return lbe.setPlaying((Boolean)state.m_61143_((Property)PLAYING) == false, state);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pLevel.f_46443_) {
            return InteractionResult.CONSUME;
        }
        BlockEntity be = pLevel.m_7702_(pPos);
        if (!(be instanceof LooperBlockEntity)) {
            return InteractionResult.FAIL;
        }
        LooperBlockEntity lbe = (LooperBlockEntity)be;
        ItemStack heldStack = pPlayer.m_21120_(pHand);
        return this.performChainedInteractions(List.of(this::insertRecord, this::cycleLooping, this::validateRecordPresence, this::pairInstrumentItem, this::ejectRecord, this::cyclePlaying), interaction -> interaction.run(pState, pLevel, pPos, pPlayer, lbe, heldStack, pHit));
    }

    protected InteractionResult performChainedInteractions(List<LooperInteractionRunnable> interactions, Function<LooperInteractionRunnable, InteractionResult> performer) {
        for (LooperInteractionRunnable interaction : interactions) {
            InteractionResult result = performer.apply(interaction);
            if (result == InteractionResult.FAIL) continue;
            return result;
        }
        return InteractionResult.FAIL;
    }

    protected InteractionResult cycleLooping(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, LooperBlockEntity lbe, ItemStack heldStack, BlockHitResult pHit) {
        if (pHit.m_82434_() != this.getLoopDir(pState)) {
            return InteractionResult.FAIL;
        }
        pLevel.m_46597_(pPos, (BlockState)pState.m_61122_((Property)LOOPING));
        return InteractionResult.SUCCESS;
    }

    protected InteractionResult insertRecord(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, LooperBlockEntity lbe, ItemStack heldStack, BlockHitResult pHit) {
        if (!(heldStack.m_41720_() instanceof EMIRecordItem)) {
            return InteractionResult.FAIL;
        }
        if (((Boolean)pState.m_61143_((Property)RECORD_IN)).booleanValue()) {
            lbe.popRecord();
        }
        lbe.setItem(0, heldStack);
        ModCriteria.RECORD_INJECTED_TRIGGER.trigger((ServerPlayer)pPlayer, heldStack);
        if (!pPlayer.m_7500_()) {
            heldStack.m_41774_(1);
        }
        if (!lbe.hasFootage()) {
            pPlayer.m_5661_((Component)Component.m_237115_((String)"evenmoreinstruments.record.no_footage"), true);
        }
        return InteractionResult.SUCCESS;
    }

    protected InteractionResult validateRecordPresence(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, LooperBlockEntity lbe, ItemStack heldStack, BlockHitResult pHit) {
        if (!((Boolean)pState.m_61143_((Property)RECORD_IN)).booleanValue()) {
            pPlayer.m_5661_((Component)Component.m_237115_((String)"evenmoreinstruments.looper.no_record").m_130940_(ChatFormatting.RED), true);
            return InteractionResult.CONSUME_PARTIAL;
        }
        return InteractionResult.FAIL;
    }

    protected InteractionResult ejectRecord(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, LooperBlockEntity lbe, ItemStack heldStack, BlockHitResult pHit) {
        if (!((Boolean)pState.m_61143_((Property)RECORD_IN)).booleanValue()) {
            return InteractionResult.FAIL;
        }
        if (pPlayer.m_6144_() || !lbe.hasFootage()) {
            lbe.popRecord();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    protected InteractionResult pairInstrumentItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, LooperBlockEntity lbe, ItemStack heldStack, BlockHitResult pHit) {
        if (!(heldStack.m_41720_() instanceof InstrumentItem)) {
            return InteractionResult.FAIL;
        }
        if (lbe.isWritable()) {
            if (LooperUtil.performPair(lbe, () -> LooperUtil.createLooperTag(heldStack, pPos), pPlayer)) {
                return InteractionResult.SUCCESS;
            }
        } else {
            pPlayer.m_5661_((Component)Component.m_237115_((String)"evenmoreinstruments.record.not_writable").m_130940_(ChatFormatting.YELLOW), true);
            return InteractionResult.FAIL;
        }
        return InteractionResult.FAIL;
    }

    protected InteractionResult cyclePlaying(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, LooperBlockEntity lbe, ItemStack heldStack, BlockHitResult pHit) {
        if (!lbe.hasFootage()) {
            if (lbe.isWritable()) {
                pPlayer.m_5661_((Component)Component.m_237115_((String)"evenmoreinstruments.record.no_footage"), true);
            }
            return InteractionResult.CONSUME_PARTIAL;
        }
        pLevel.m_46597_(pPos, (BlockState)LooperBlock.cyclePlaying(lbe, pState).m_61124_((Property)REDSTONE_TRIGGERED, (Comparable)Boolean.valueOf(false)));
        return InteractionResult.SUCCESS;
    }

    public void m_5707_(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        super.m_5707_(pLevel, pPos, pState, pPlayer);
        if (pLevel.m_5776_()) {
            return;
        }
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (!(blockEntity instanceof LooperBlockEntity)) {
            return;
        }
        LooperBlockEntity lbe = (LooperBlockEntity)blockEntity;
        lbe.popRecord();
    }

    public Direction getLoopDir(BlockState state) {
        return ((Direction)state.m_61143_((Property)FACING)).m_122424_();
    }

    public Direction getPlayDir(BlockState state) {
        return (Direction)state.m_61143_((Property)FACING);
    }

    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pNeighborBlock, BlockPos pNeighborPos, boolean pMovedByPiston) {
        if (pLevel.f_46443_) {
            return;
        }
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (!(blockEntity instanceof LooperBlockEntity)) {
            return;
        }
        LooperBlockEntity lbe = (LooperBlockEntity)blockEntity;
        boolean wasRedstoneTriggered = (Boolean)pState.m_61143_((Property)REDSTONE_TRIGGERED);
        if (pLevel.m_46753_(pPos)) {
            if (!wasRedstoneTriggered) {
                lbe.setTicks(0);
                BlockState newState = pState;
                newState = (Boolean)pState.m_61143_((Property)LOOPING) != false ? LooperBlock.cyclePlaying(lbe, newState) : lbe.setPlaying(true, newState);
                pLevel.m_46597_(pPos, (BlockState)newState.m_61124_((Property)REDSTONE_TRIGGERED, (Comparable)Boolean.valueOf(true)));
            }
        } else if (wasRedstoneTriggered) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)REDSTONE_TRIGGERED, (Comparable)Boolean.valueOf(false)), 1);
        }
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return this.getPlayDir(state).m_122424_() == direction;
    }

    public boolean m_7278_(BlockState pState) {
        return true;
    }

    public int m_6782_(BlockState pState, Level pLevel, BlockPos pPos) {
        return ((Boolean)pState.m_61143_((Property)PLAYING) != false ? 1 : 0) * 15;
    }

    public boolean m_8133_(BlockState pState, Level pLevel, BlockPos pPos, int pId, int pParam) {
        switch (pId) {
            case 42: {
                return this.emitNoteParticle(pLevel, pPos, pParam);
            }
        }
        return false;
    }

    protected boolean emitNoteParticle(Level level, BlockPos pos, int noteIndex) {
        level.m_7106_((ParticleOptions)ParticleTypes.f_123758_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.2, (double)pos.m_123343_() + 0.5, (double)noteIndex / 24.0, 0.0, 0.0);
        return true;
    }
}

