/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.util.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ClientTextUtils {
    @OnlyIn(value=Dist.CLIENT)
    public static Component getComponentWithWidthCutoff(Component component, int maxWidth) {
        Font font = Minecraft.m_91087_().f_91062_;
        if (font.m_92852_((FormattedText)component) > maxWidth) {
            Object substr = font.m_92834_(component.getString(), maxWidth);
            substr = ((String)substr).endsWith(" ") ? ((String)substr).substring(0, ((String)substr).length() - 1) + "..." : (String)substr + "...";
            return Component.m_237113_((String)substr);
        }
        return component;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderMultilineDebugText(PoseStack poseStack, MultiBufferSource buffer, int packedLight, double baseY, boolean transparent, String ... lines) {
        double y = baseY + (double)lines.length / 4.0;
        for (String line : lines) {
            ClientTextUtils.renderDebugText(poseStack, buffer, packedLight, y, transparent, line);
            y -= 0.25;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderDebugText(PoseStack poseStack, MultiBufferSource pBuffer, int pPackedLight, double y, boolean transparent, String text) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, y, 0.0);
        poseStack.m_85845_(Minecraft.m_91087_().m_167982_().f_112249_.m_90591_());
        poseStack.m_85841_(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
        float f1 = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
        int j = (int)(f1 * 255.0f) << 24;
        Font font = Minecraft.m_91087_().f_91062_;
        float f2 = -font.m_92895_(text) / 2;
        font.m_92811_(text, f2, 0.0f, 0x20FFFFFF, false, matrix4f, pBuffer, transparent, j, pPackedLight);
        if (transparent) {
            font.m_92811_(text, f2, 0.0f, -1, false, matrix4f, pBuffer, false, 0, pPackedLight);
        }
        poseStack.m_85849_();
    }
}

