/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.switches;

import com.mojang.blaze3d.vertex.PoseStack;
import com.railwayteam.railways.content.switches.TrackSwitchBlock;
import com.railwayteam.railways.mixin.client.AccessorControlsHandler;
import com.railwayteam.railways.registry.CRGuiTextures;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.actors.trainControls.ControlsHandler;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GameType;
import org.jetbrains.annotations.Nullable;

public class TrainHUDSwitchExtension {
    @Nullable
    public static TrackSwitchBlock.SwitchState switchState;
    public static boolean isAutomaticSwitch;
    public static boolean isWrong;
    public static boolean isLocked;
    static LerpedFloat switchProgress;

    public static void tick() {
        if (AccessorControlsHandler.getEntityRef().get() == null) {
            switchState = null;
        }
        switchProgress.chase(switchState != null ? 1.0 : 0.0, 0.5, LerpedFloat.Chaser.EXP);
        switchProgress.tickChaser();
    }

    private static Carriage getCarriage() {
        AbstractContraptionEntity abstractContraptionEntity = ControlsHandler.getContraption();
        if (!(abstractContraptionEntity instanceof CarriageContraptionEntity)) {
            return null;
        }
        CarriageContraptionEntity cce = (CarriageContraptionEntity)abstractContraptionEntity;
        return cce.getCarriage();
    }

    public static void renderOverlay(PoseStack poseStack, float partialTicks, int width, int height) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92062_ || mc.f_91072_.m_105295_() == GameType.SPECTATOR) {
            return;
        }
        AbstractContraptionEntity abstractContraptionEntity = ControlsHandler.getContraption();
        if (!(abstractContraptionEntity instanceof CarriageContraptionEntity)) {
            return;
        }
        CarriageContraptionEntity cce = (CarriageContraptionEntity)abstractContraptionEntity;
        Carriage carriage = cce.getCarriage();
        if (carriage == null) {
            return;
        }
        Entity cameraEntity = Minecraft.m_91087_().m_91288_();
        if (cameraEntity == null) {
            return;
        }
        BlockPos localPos = ControlsHandler.getControlsPos();
        if (localPos == null) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_((double)(width / 2 - 91), (double)(height - 29), 0.0);
        if (switchProgress.getValue(partialTicks) > 0.0f) {
            CRGuiTextures bg = isAutomaticSwitch ? CRGuiTextures.TRAIN_HUD_SWITCH_BRASS : CRGuiTextures.TRAIN_HUD_SWITCH_ANDESITE;
            bg.bind();
            GuiComponent.m_93143_((PoseStack)poseStack, (int)131, (int)((int)((double)(-16.0f * switchProgress.getValue(partialTicks)) - 0.5)), (int)0, (float)bg.startX, (float)bg.startY, (int)bg.width, (int)((int)((double)((float)bg.height * switchProgress.getValue(partialTicks)) + 0.5)), (int)256, (int)256);
        }
        if ((double)switchProgress.getValue(partialTicks) > 0.99 && switchState != null) {
            switch (switchState) {
                case NORMAL: {
                    CRGuiTextures.getForSwitch(switchState, isWrong).render(poseStack, 152, -13);
                    break;
                }
                case REVERSE_LEFT: {
                    CRGuiTextures.getForSwitch(switchState, isWrong).render(poseStack, 142, -13);
                    break;
                }
                case REVERSE_RIGHT: {
                    CRGuiTextures.getForSwitch(switchState, isWrong).render(poseStack, 162, -13);
                }
            }
            if (isLocked) {
                CRGuiTextures.TRAIN_HUD_SWITCH_LOCKED.render(poseStack, 134, -13);
            }
        }
        poseStack.m_85849_();
    }

    static {
        isAutomaticSwitch = false;
        isWrong = false;
        isLocked = false;
        switchProgress = LerpedFloat.linear();
    }
}

