/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.palettes.boiler;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import com.railwayteam.railways.content.palettes.boiler.forge.BoilerBlockPlacementHelperImpl;
import com.railwayteam.railways.mixin_interfaces.IForceRenderingSodium;
import com.railwayteam.railways.mixin_interfaces.IHasCustomOutline;
import com.railwayteam.railways.registry.CRShapes;
import com.simibubi.create.content.equipment.extendoGrip.ExtendoGripItem;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IHaveBigOutline;
import com.simibubi.create.foundation.placement.IPlacementHelper;
import com.simibubi.create.foundation.placement.PlacementHelpers;
import com.simibubi.create.foundation.placement.PlacementOffset;
import com.simibubi.create.foundation.placement.PoleHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.infrastructure.config.AllConfigs;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BoilerBlock
extends Block
implements IWrenchable,
IForceRenderingSodium,
IHasCustomOutline,
IHaveBigOutline {
    public static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());
    public static final EnumProperty<Style> STYLE = EnumProperty.m_61587_((String)"style", Style.class);
    public static final EnumProperty<Direction.Axis> HORIZONTAL_AXIS = BlockStateProperties.f_61364_;
    public static final BooleanProperty RAISED = BooleanProperty.m_61465_((String)"raised");

    public BoilerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(STYLE, (Comparable)((Object)Style.GULLET))).m_61124_(HORIZONTAL_AXIS, (Comparable)Direction.Axis.X)).m_61124_((Property)RAISED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{STYLE, HORIZONTAL_AXIS, RAISED});
    }

    public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        if (targetedFace.m_122434_() == originalState.m_61143_(HORIZONTAL_AXIS)) {
            return (BlockState)originalState.m_61122_(STYLE);
        }
        return super.getRotatedBlockState(originalState, targetedFace);
    }

    public boolean m_6104_(@NotNull BlockState state, BlockState adjacentBlockState, @NotNull Direction direction) {
        return adjacentBlockState.m_60713_((Block)this) && adjacentBlockState.m_61143_(HORIZONTAL_AXIS) == state.m_61143_(HORIZONTAL_AXIS) && adjacentBlockState.m_61143_((Property)RAISED) == state.m_61143_((Property)RAISED);
    }

    @Override
    public boolean forceRenderingSodium(@NotNull BlockState state, BlockState adjacentBlockState, @NotNull Direction direction) {
        return !this.m_6104_(state, adjacentBlockState, direction);
    }

    @NotNull
    public VoxelShape m_7952_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return Shapes.m_83040_();
    }

    public float m_7749_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return 1.0f;
    }

    @NotNull
    public BlockState m_6843_(@NotNull BlockState state, Rotation rotation) {
        return switch (rotation) {
            case Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90 -> (BlockState)state.m_61122_(HORIZONTAL_AXIS);
            default -> state;
        };
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        boolean raised = context.m_43723_() != null && context.m_43723_().m_6144_();
        Direction.Axis axis = context.m_43719_().m_122434_();
        if (axis == Direction.Axis.Y) {
            axis = context.m_8125_().m_122434_();
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_(HORIZONTAL_AXIS, (Comparable)axis)).m_61124_((Property)RAISED, (Comparable)Boolean.valueOf(raised));
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (player.m_6144_() || !player.m_36326_()) {
            return InteractionResult.PASS;
        }
        ItemStack heldItem = player.m_21120_(hand);
        IPlacementHelper helper = PlacementHelpers.get((int)placementHelperId);
        if (helper.matchesItem(heldItem)) {
            return helper.getOffset(player, level, state, pos, hit).placeInWorld(level, (BlockItem)heldItem.m_41720_(), player, hand, hit);
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.getShapeForState(state);
    }

    @NotNull
    public VoxelShape m_5939_(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.getShapeForState(state);
    }

    @NotNull
    public VoxelShape m_6079_(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return this.getShapeForState(state);
    }

    @NotNull
    public VoxelShape getShapeForState(BlockState state) {
        if (((Boolean)state.m_61143_((Property)RAISED)).booleanValue()) {
            return CRShapes.BOILER_RAISED.get((Direction.Axis)state.m_61143_(HORIZONTAL_AXIS));
        }
        return CRShapes.BOILER.get((Direction.Axis)state.m_61143_(HORIZONTAL_AXIS));
    }

    @Override
    public void customOutline(PoseStack poseStack, VertexConsumer consumer, BlockState state) {
        double offset = (Boolean)state.m_61143_((Property)RAISED) != false ? 8.0 : 0.0;
        for (int zeroAndOne : Iterate.zeroAndOne) {
            int i = zeroAndOne * 16;
            this.drawLineWithAxisOffset(consumer, poseStack, 1.37258, -8.0, i, -8.0, 1.37258, i, offset, Direction.Axis.Y);
            this.drawLineWithAxisOffset(consumer, poseStack, -8.0, 1.37258, i, -8.0, 14.6274, i, offset, Direction.Axis.Y);
            this.drawLineWithAxisOffset(consumer, poseStack, -8.0, 14.6274, i, 1.37258, 24.0, i, offset, Direction.Axis.Y);
            this.drawLineWithAxisOffset(consumer, poseStack, 1.37258, 24.0, i, 14.6274, 24.0, i, offset, Direction.Axis.Y);
            this.drawLineWithAxisOffset(consumer, poseStack, 14.6274, 24.0, i, 24.0, 14.6274, i, offset, Direction.Axis.Y);
            this.drawLineWithAxisOffset(consumer, poseStack, 24.0, 14.6274, i, 24.0, 1.37258, i, offset, Direction.Axis.Y);
            this.drawLineWithAxisOffset(consumer, poseStack, 24.0, 1.37258, i, 14.6274, -8.0, i, offset, Direction.Axis.Y);
            this.drawLineWithAxisOffset(consumer, poseStack, 14.6274, -8.0, i, 1.37258, -8.0, i, offset, Direction.Axis.Y);
        }
        this.drawLineWithAxisOffset(consumer, poseStack, 1.37258, -8.0, 0.0, 1.37258, -8.0, 16.0, offset, Direction.Axis.Y);
        this.drawLineWithAxisOffset(consumer, poseStack, -8.0, 1.37258, 0.0, -8.0, 1.37258, 16.0, offset, Direction.Axis.Y);
        this.drawLineWithAxisOffset(consumer, poseStack, -8.0, 14.6274, 0.0, -8.0, 14.6274, 16.0, offset, Direction.Axis.Y);
        this.drawLineWithAxisOffset(consumer, poseStack, 1.37258, 24.0, 0.0, 1.37258, 24.0, 16.0, offset, Direction.Axis.Y);
        this.drawLineWithAxisOffset(consumer, poseStack, 14.6274, 24.0, 0.0, 14.6274, 24.0, 16.0, offset, Direction.Axis.Y);
        this.drawLineWithAxisOffset(consumer, poseStack, 24.0, 14.6274, 0.0, 24.0, 14.6274, 16.0, offset, Direction.Axis.Y);
        this.drawLineWithAxisOffset(consumer, poseStack, 24.0, 1.37258, 0.0, 24.0, 1.37258, 16.0, offset, Direction.Axis.Y);
        this.drawLineWithAxisOffset(consumer, poseStack, 14.6274, -8.0, 0.0, 14.6274, -8.0, 16.0, offset, Direction.Axis.Y);
    }

    @Override
    public void matrixRotation(PoseStack poseStack, BlockState state) {
        if (state.m_61143_(HORIZONTAL_AXIS) == Direction.Axis.X) {
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        }
    }

    public static enum Style implements StringRepresentable
    {
        GULLET("boiler_gullet"),
        SMOKEBOX("smokebox_door");

        private final String texture;

        private Style(String texture) {
            this.texture = texture;
        }

        @NotNull
        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public String getTexture() {
            return this.texture;
        }
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    extends PoleHelper<Direction.Axis> {
        private PlacementHelper() {
            super(state -> state.m_60734_() instanceof BoilerBlock, state -> (Direction.Axis)state.m_61143_(HORIZONTAL_AXIS), HORIZONTAL_AXIS);
        }

        public Predicate<ItemStack> getItemPredicate() {
            return i -> {
                BlockItem blockItem;
                Item patt11852$temp = i.m_41720_();
                return patt11852$temp instanceof BlockItem && (blockItem = (BlockItem)patt11852$temp).m_40614_() instanceof BoilerBlock;
            };
        }

        public Predicate<BlockState> getStatePredicate() {
            return state -> state.m_60734_() instanceof BoilerBlock;
        }

        public PlacementOffset getOffset(Player player, Level level, BlockState state, BlockPos pos, BlockHitResult ray) {
            PlacementOffset offset = PlacementOffset.fail();
            List directions = IPlacementHelper.orderedByDistance((BlockPos)pos, (Vec3)ray.m_82450_(), dir -> dir.m_122434_() == this.axisFunction.apply(state));
            for (Direction dir2 : directions) {
                BlockPos newPos;
                BlockState newState;
                int poles;
                AttributeInstance reach;
                dir2 = dir2.m_122424_();
                int range = (Integer)AllConfigs.server().equipment.placementAssistRange.get();
                if (player != null && (reach = player.m_21051_(PlacementHelper.getAttribute())) != null && reach.m_22109_(ExtendoGripItem.singleRangeAttributeModifier)) {
                    range += 4;
                }
                if ((poles = this.attachedPoles(level, pos, dir2)) >= range || !(newState = level.m_8055_(newPos = pos.m_5484_(dir2, poles + 1))).m_60767_().m_76336_()) continue;
                offset = PlacementOffset.success((Vec3i)newPos, bState -> (BlockState)bState.m_61124_(HORIZONTAL_AXIS, (Comparable)((Direction.Axis)state.m_61143_(HORIZONTAL_AXIS))));
            }
            if (offset.isSuccessful()) {
                offset.withTransform(offset.getTransform().andThen(s -> (BlockState)s.m_61124_((Property)RAISED, (Comparable)((Boolean)state.m_61143_((Property)RAISED)))));
            }
            return offset;
        }

        @ExpectPlatform
        @ExpectPlatform.Transformed
        public static Attribute getAttribute() {
            return BoilerBlockPlacementHelperImpl.getAttribute();
        }
    }
}

