/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.coupling.coupler;

import com.railwayteam.railways.content.coupling.coupler.TrackCouplerBlockEntity;
import com.railwayteam.railways.content.coupling.coupler.forge.TrackCouplerBlockImpl;
import com.railwayteam.railways.registry.CRBlockEntities;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TrackCouplerBlock
extends Block
implements IBE<TrackCouplerBlockEntity>,
IWrenchable {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final EnumProperty<TrackCouplerBlockEntity.AllowedOperationMode> MODE = EnumProperty.m_61587_((String)"mode", TrackCouplerBlockEntity.AllowedOperationMode.class);

    protected TrackCouplerBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_(MODE, (Comparable)((Object)TrackCouplerBlockEntity.AllowedOperationMode.BOTH)));
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static TrackCouplerBlock create(BlockBehaviour.Properties properties) {
        return TrackCouplerBlockImpl.create(properties);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder.m_61104_(new Property[]{POWERED}).m_61104_(new Property[]{MODE}));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(pContext.m_43725_().m_46753_(pContext.m_8083_())));
    }

    @Deprecated
    public boolean m_7278_(@NotNull BlockState state) {
        return true;
    }

    @Deprecated
    public int m_6782_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TrackCouplerBlockEntity) {
            TrackCouplerBlockEntity te = (TrackCouplerBlockEntity)blockEntity;
            return te.getTargetAnalogOutput();
        }
        return 0;
    }

    public Class<TrackCouplerBlockEntity> getBlockEntityClass() {
        return TrackCouplerBlockEntity.class;
    }

    public BlockEntityType<? extends TrackCouplerBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CRBlockEntities.TRACK_COUPLER.get();
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        IBE.onRemove((BlockState)state, (Level)worldIn, (BlockPos)pos, (BlockState)newState);
    }

    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        if (pLevel.f_46443_) {
            return;
        }
        boolean powered = (Boolean)pState.m_61143_((Property)POWERED);
        if (powered == pLevel.m_46753_(pPos)) {
            return;
        }
        if (powered) {
            pLevel.m_186460_(pPos, (Block)this, 4);
        } else {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61122_((Property)POWERED), 2);
        }
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRand) {
        if (((Boolean)pState.m_61143_((Property)POWERED)).booleanValue() && !pLevel.m_46753_(pPos)) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61122_((Property)POWERED), 2);
        }
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        Level level = context.m_43725_();
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockPos pos = context.m_8083_();
        BlockState newState = (BlockState)state.m_61122_(MODE);
        level.m_7731_(pos, newState, 3);
        Player player = context.m_43723_();
        if (player != null) {
            player.m_5661_(((TrackCouplerBlockEntity.AllowedOperationMode)((Object)newState.m_61143_(MODE))).getTranslatedName(), true);
        }
        return InteractionResult.SUCCESS;
    }
}

