/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.network.s2c;

import immersive_aircraft.cobalt.network.Message;
import immersive_aircraft.item.upgrade.AircraftStat;
import immersive_aircraft.item.upgrade.AircraftUpgrade;
import immersive_aircraft.item.upgrade.AircraftUpgradeRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public class AircraftUpgradesMessage
extends Message {
    private final Map<Item, AircraftUpgrade> upgrades;

    public AircraftUpgradesMessage() {
        this.upgrades = AircraftUpgradeRegistry.INSTANCE.getAll();
    }

    public AircraftUpgradesMessage(FriendlyByteBuf buffer) {
        this.upgrades = new HashMap<Item, AircraftUpgrade>();
        int upgradeCount = buffer.readInt();
        for (int i = 0; i < upgradeCount; ++i) {
            Item item = (Item)Registry.f_122827_.m_7745_(buffer.m_130281_());
            this.upgrades.put(item, this.readUpgrade(buffer));
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        Map<Item, AircraftUpgrade> upgrades = AircraftUpgradeRegistry.INSTANCE.getAll();
        buffer.writeInt(upgrades.size());
        for (Item item : upgrades.keySet()) {
            buffer.m_130085_(Registry.f_122827_.m_7981_((Object)item));
            this.writeUpgrade(buffer, upgrades.get(item));
        }
    }

    protected void writeUpgrade(FriendlyByteBuf buffer, AircraftUpgrade upgrade) {
        Map<AircraftStat, Float> upgradeMap = upgrade.getAll();
        buffer.writeInt(upgradeMap.size());
        for (AircraftStat stat : upgradeMap.keySet()) {
            buffer.m_130070_(stat.name());
            buffer.writeFloat(upgradeMap.get(stat).floatValue());
        }
    }

    protected AircraftUpgrade readUpgrade(FriendlyByteBuf buffer) {
        AircraftUpgrade upgrade = new AircraftUpgrade();
        int statCount = buffer.readInt();
        for (int j = 0; j < statCount; ++j) {
            upgrade.set(AircraftStat.STATS.get(buffer.m_130277_()), buffer.readFloat());
        }
        return upgrade;
    }

    @Override
    public void receive(Player player) {
        AircraftUpgradeRegistry.INSTANCE.replace(this.upgrades);
    }
}

