/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.network.c2s;

import com.mojang.math.Vector3f;
import immersive_aircraft.cobalt.network.Message;
import immersive_aircraft.entity.InventoryVehicleEntity;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class FireMessage
extends Message {
    private final int slot;
    private final int index;
    public final Vector3f direction;

    public FireMessage(int slot, int index, Vector3f direction) {
        this.slot = slot;
        this.index = index;
        this.direction = direction;
    }

    public FireMessage(FriendlyByteBuf b) {
        this.slot = b.readInt();
        this.index = b.readInt();
        this.direction = new Vector3f(b.readFloat(), b.readFloat(), b.readFloat());
    }

    public int getSlot() {
        return this.slot;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public void encode(FriendlyByteBuf b) {
        b.writeInt(this.slot);
        b.writeInt(this.index);
        b.writeFloat(this.direction.m_122239_());
        b.writeFloat(this.direction.m_122260_());
        b.writeFloat(this.direction.m_122269_());
    }

    @Override
    public void receive(Player e) {
        Entity entity = e.m_20202_();
        if (entity instanceof InventoryVehicleEntity) {
            InventoryVehicleEntity vehicle = (InventoryVehicleEntity)entity;
            vehicle.getWeapons().get(this.slot).get(this.index).fire(this.direction);
        }
    }
}

