/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.network.c2s;

import immersive_aircraft.cobalt.network.Message;
import immersive_aircraft.entity.InventoryVehicleEntity;
import immersive_aircraft.entity.VehicleEntity;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class CommandMessage
extends Message {
    private final Key key;
    private final double fx;
    private final double fy;
    private final double fz;

    public CommandMessage(Key key, Vec3 velocity) {
        this.key = key;
        this.fx = velocity.f_82479_;
        this.fy = velocity.f_82480_;
        this.fz = velocity.f_82481_;
    }

    public CommandMessage(FriendlyByteBuf b) {
        this.key = Key.values()[b.readInt()];
        this.fx = b.readDouble();
        this.fy = b.readDouble();
        this.fz = b.readDouble();
    }

    @Override
    public void encode(FriendlyByteBuf b) {
        b.writeInt(this.key.ordinal());
        b.writeDouble(this.fx);
        b.writeDouble(this.fy);
        b.writeDouble(this.fz);
    }

    @Override
    public void receive(Player e) {
        VehicleEntity vehicle;
        Entity entity = e.m_20201_();
        if (entity instanceof VehicleEntity) {
            vehicle = (VehicleEntity)entity;
            if (this.key == Key.DISMOUNT) {
                e.m_8127_();
                e.m_6862_(false);
                vehicle.chill();
                vehicle.m_20334_(this.fx, this.fy, this.fz);
            } else if (this.key == Key.BOOST && vehicle.canBoost()) {
                vehicle.boost();
            }
        }
        if ((entity = e.m_20201_()) instanceof InventoryVehicleEntity) {
            vehicle = (InventoryVehicleEntity)entity;
            if (this.key == Key.INVENTORY) {
                ((InventoryVehicleEntity)vehicle).openInventory((ServerPlayer)e);
            }
        }
    }

    public static enum Key {
        DISMOUNT,
        INVENTORY,
        BOOST,
        DAMAGE;

    }
}

