/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity.weapons;

import com.mojang.math.Matrix3f;
import com.mojang.math.Vector3f;
import immersive_aircraft.Main;
import immersive_aircraft.entity.VehicleEntity;
import immersive_aircraft.entity.weapons.Weapon;
import net.minecraft.world.entity.Entity;

public class RotationalManager {
    private final Weapon weapon;
    float yaw = 0.0f;
    float pitch = 0.0f;
    float roll = 0.0f;
    float lastYaw = 0.0f;
    float lastPitch = 0.0f;
    float lastRoll = 0.0f;

    public RotationalManager(Weapon weapon) {
        this.weapon = weapon;
    }

    private float turn(float diff) {
        if ((double)diff > Math.PI) {
            diff -= (float)Math.PI * 2;
        } else if ((double)diff < -Math.PI) {
            diff += (float)Math.PI * 2;
        }
        return diff;
    }

    public float getPitch(float tickDelta) {
        float diff = this.turn(this.pitch - this.lastPitch);
        return this.lastPitch + diff * tickDelta;
    }

    public float getYaw(float tickDelta) {
        float diff = this.turn(this.yaw - this.lastYaw);
        return this.lastYaw + diff * tickDelta;
    }

    public float getRoll(float tickDelta) {
        float diff = this.turn(this.roll - this.lastRoll);
        return this.lastRoll + diff * tickDelta;
    }

    public void tick() {
        this.lastYaw = this.yaw;
        this.lastPitch = this.pitch;
        this.lastRoll = this.roll;
    }

    public Matrix3f getCamera(VehicleEntity vehicle, Entity pilot) {
        Matrix3f camera = new Matrix3f();
        camera.m_8180_();
        if (vehicle.adaptPlayerRotation && Main.firstPersonGetter.isFirstPerson()) {
            camera.m_8171_(Vector3f.f_122227_.m_122240_(vehicle.getRoll()));
            camera.m_8171_(Vector3f.f_122223_.m_122240_(vehicle.m_146909_()));
        }
        camera.m_8171_(Vector3f.f_122223_.m_122240_(pilot.m_146909_()));
        camera.m_8171_(Vector3f.f_122225_.m_122240_(pilot.m_146908_() + 180.0f));
        return camera;
    }

    public void pointTo(VehicleEntity vehicle) {
        this.pointTo(vehicle, new Vector3f(0.0f, 0.0f, -1.0f));
    }

    public void pointTo(VehicleEntity vehicle, Vector3f normal) {
        this.screenToGlobal(vehicle, normal);
        Matrix3f vehicleTransform = vehicle.getVehicleNormalTransform().m_8183_();
        vehicleTransform.m_8187_();
        normal.m_122249_(vehicleTransform);
        this.yaw = (float)(-Math.atan2(normal.m_122239_(), normal.m_122269_()));
        this.pitch = (float)(-Math.atan2(normal.m_122260_(), Math.sqrt(normal.m_122239_() * normal.m_122239_() + normal.m_122269_() * normal.m_122269_())));
    }

    public Vector3f screenToGlobal(VehicleEntity vehicle) {
        return this.screenToGlobal(vehicle, new Vector3f(0.0f, 0.0f, -1.0f));
    }

    public Vector3f screenToGlobal(VehicleEntity vehicle, Vector3f normal) {
        Entity pilot = vehicle.getGunner(this.weapon.getGunnerOffset());
        if (pilot != null) {
            Matrix3f camera = this.getCamera(vehicle, pilot);
            camera.m_8187_();
            normal.m_122249_(camera);
        }
        return normal;
    }
}

