/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity.weapons;

import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import immersive_aircraft.cobalt.network.NetworkHandler;
import immersive_aircraft.entity.InventoryVehicleEntity;
import immersive_aircraft.entity.VehicleEntity;
import immersive_aircraft.entity.misc.WeaponMount;
import immersive_aircraft.entity.weapons.Weapon;
import immersive_aircraft.network.s2c.FireResponse;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public abstract class BulletWeapon
extends Weapon {
    private final Random random = new Random();
    private ItemStack ammoStack;
    private int ammo;

    public BulletWeapon(VehicleEntity entity, ItemStack stack, WeaponMount mount, int slot) {
        super(entity, stack, mount, slot);
    }

    protected float getBarrelLength() {
        return 1.0f;
    }

    protected Vector4f getBarrelOffset() {
        return new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
    }

    protected int getBulletCount() {
        return 1;
    }

    protected abstract Entity getBullet(Entity var1, Vector4f var2, Vector3f var3);

    @Override
    public void fire(Vector3f direction) {
        Vector4f position = this.getBarrelOffset();
        VehicleEntity entity = this.getEntity();
        position.m_123607_(this.getMount().transform());
        position.m_123607_(entity.getVehicleTransform());
        Vec3 speed = entity.getSpeedVector();
        float barrelLength = this.getBarrelLength();
        position.m_176875_(direction.m_122239_() * barrelLength, direction.m_122260_() * barrelLength, direction.m_122269_() * barrelLength, 0.0f);
        for (int i = 0; i < this.getBulletCount(); ++i) {
            Entity bullet = this.getBullet(entity, position, direction);
            bullet.m_20256_(bullet.m_20184_().m_82549_(speed));
            entity.m_9236_().m_7967_(bullet);
        }
        direction.m_122261_(0.25f);
        direction.m_122272_((float)speed.f_82479_, (float)speed.f_82480_, (float)speed.f_82481_);
        FireResponse fireMessage = new FireResponse(position, direction);
        for (ServerPlayer player : ((ServerLevel)entity.m_9236_()).m_6907_()) {
            NetworkHandler.sendToPlayer(fireMessage, player);
        }
        this.getEntity().m_5496_(this.getSound(), 1.0f, this.random.nextFloat() * 0.2f + 0.9f);
    }

    public SoundEvent getSound() {
        return SoundEvents.f_11847_;
    }

    protected boolean spentAmmo(Map<String, Integer> ammunition, int amount) {
        VehicleEntity vehicleEntity;
        if (this.getEntity().isPilotCreative()) {
            return true;
        }
        if (this.ammo < amount && (vehicleEntity = this.getEntity()) instanceof InventoryVehicleEntity) {
            InventoryVehicleEntity vehicle = (InventoryVehicleEntity)vehicleEntity;
            for (int i = 0; i < vehicle.getInventory().m_6643_(); ++i) {
                ItemStack stack = vehicle.getInventory().m_8020_(i);
                String key = Registry.f_122827_.m_7981_((Object)stack.m_41720_()).toString();
                if (!ammunition.containsKey(key)) continue;
                this.ammo += ammunition.get(key).intValue();
                this.ammoStack = stack.m_41777_();
                stack.m_41774_(1);
                if (this.ammo >= amount) break;
            }
        }
        if (this.ammo <= 0) {
            vehicleEntity = this.getEntity().m_6688_();
            if (vehicleEntity instanceof Player) {
                Player player = (Player)vehicleEntity;
                player.m_5661_((Component)Component.m_237115_((String)"immersive_aircraft.out_of_ammo"), true);
            }
            return false;
        }
        this.ammo -= amount;
        return true;
    }

    public ItemStack getAmmoStack() {
        return this.ammoStack;
    }

    public int getAmmo() {
        return this.ammo;
    }
}

