/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.Items;
import immersive_aircraft.Sounds;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.Rotorcraft;
import immersive_aircraft.item.upgrade.AircraftStat;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class QuadrocopterEntity
extends Rotorcraft {
    public QuadrocopterEntity(EntityType<? extends AircraftEntity> entityType, Level world) {
        super(entityType, world, true);
        this.adaptPlayerRotation = false;
    }

    @Override
    protected float getInputInterpolationSteps() {
        return 5.0f;
    }

    @Override
    protected SoundEvent getEngineSound() {
        return Sounds.PROPELLER_TINY.get();
    }

    @Override
    public Item asItem() {
        return Items.QUADROCOPTER.get();
    }

    @Override
    protected float getGravity() {
        return this.f_19798_ ? 0.04f : (1.0f - this.getEnginePower()) * super.getGravity();
    }

    @Override
    protected void updateController() {
        this.setEngineTarget(1.0f);
        if (!this.f_19861_) {
            this.m_146926_(this.m_146909_() + this.getProperties().get(AircraftStat.PITCH_SPEED) * this.pressingInterpolatedZ.getSmooth());
        }
        this.m_146926_(this.m_146909_() * (1.0f - this.getProperties().getAdditive(AircraftStat.STABILIZER)));
        this.m_20256_(this.m_20184_().m_82520_(0.0, (double)(this.getEnginePower() * this.getProperties().get(AircraftStat.VERTICAL_SPEED) * this.pressingInterpolatedY.getSmooth()), 0.0));
        Entity pilot = this.m_6688_();
        if (pilot != null) {
            float diff = pilot.m_6080_() - this.m_146908_();
            if (diff > 180.0f) {
                diff -= 360.0f;
            } else if (diff < -180.0f) {
                diff += 360.0f;
            }
            this.m_146922_(this.m_146908_() + (diff *= this.getProperties().get(AircraftStat.YAW_SPEED)));
        }
        float thrust = (float)(Math.pow(this.getEnginePower(), 5.0) * (double)this.getProperties().get(AircraftStat.ENGINE_SPEED));
        Vec3 direction = this.getRightDirection().m_82490_((double)(thrust * this.pressingInterpolatedX.getSmooth()));
        this.m_20256_(this.m_20184_().m_82549_(direction));
        direction = this.getForwardDirection().m_82490_((double)(thrust * this.pressingInterpolatedZ.getSmooth()));
        this.m_20256_(this.m_20184_().m_82549_(direction));
    }

    @Override
    protected void convertPower(Vec3 direction) {
    }
}

