/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.EngineAircraft;
import immersive_aircraft.item.upgrade.AircraftStat;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public abstract class AirplaneEntity
extends EngineAircraft {
    public AirplaneEntity(EntityType<? extends AircraftEntity> entityType, Level world, boolean canExplodeOnCrash) {
        super(entityType, world, canExplodeOnCrash);
    }

    @Override
    protected boolean useAirplaneControls() {
        return true;
    }

    @Override
    protected float getGravity() {
        Vec3 direction = this.getForwardDirection();
        float speed = (float)((double)((float)this.m_20184_().m_82553_()) * (1.0 - Math.abs(direction.m_7098_())));
        return Math.max(0.0f, 1.0f - speed * 1.5f) * super.getGravity();
    }

    protected float getBrakeFactor() {
        return 0.95f;
    }

    @Override
    protected void updateController() {
        if (!this.m_20160_()) {
            return;
        }
        super.updateController();
        if (this.movementY != 0.0f) {
            this.setEngineTarget(Math.max(0.0f, Math.min(1.0f, this.getEngineTarget() + 0.1f * this.movementY)));
            if (this.movementY < 0.0f) {
                this.m_20256_(this.m_20184_().m_82490_((double)this.getBrakeFactor()));
            }
        }
        Vec3 direction = this.getForwardDirection();
        float thrust = (float)(Math.pow(this.getEnginePower(), 2.0) * (double)this.getProperties().get(AircraftStat.ENGINE_SPEED));
        if (this.f_19861_ && (double)this.getEngineTarget() < 1.0) {
            thrust = this.getProperties().get(AircraftStat.PUSH_SPEED) / (1.0f + (float)this.m_20184_().m_82553_() * 5.0f) * this.pressingInterpolatedZ.getSmooth() * (1.0f - this.getEnginePower());
        }
        this.m_20256_(this.m_20184_().m_82549_(direction.m_82490_((double)thrust)));
    }
}

