/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import immersive_aircraft.Main;
import immersive_aircraft.data.DataLoader;
import immersive_aircraft.item.upgrade.AircraftUpgrade;
import immersive_aircraft.item.upgrade.AircraftUpgradeRegistry;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;

public class UpgradeDataLoader
extends DataLoader {
    public UpgradeDataLoader() {
        super(new Gson(), "aircraft_upgrades");
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsonMap, ResourceManager manager, ProfilerFiller profiler) {
        AircraftUpgradeRegistry.INSTANCE.reset();
        jsonMap.forEach((identifier, jsonElement) -> {
            try {
                if (Registry.f_122827_.m_7804_(identifier)) {
                    Item item = (Item)Registry.f_122827_.m_7745_(identifier);
                    AircraftUpgrade upgrade = UpgradeDataLoader.getAircraftUpgrade(jsonElement.getAsJsonObject());
                    AircraftUpgradeRegistry.INSTANCE.setUpgrade(item, upgrade);
                } else {
                    Main.LOGGER.error("There is no item {} to make it an upgrade!", identifier);
                }
            }
            catch (JsonParseException | IllegalArgumentException exception) {
                Main.LOGGER.error("Parsing error on aircraft upgrade {}: {}", identifier, (Object)exception.getMessage());
            }
        });
    }
}

