/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import immersive_aircraft.Main;
import immersive_aircraft.entity.EngineAircraft;
import immersive_aircraft.entity.InventoryVehicleEntity;
import immersive_aircraft.entity.misc.VehicleInventoryDescription;
import immersive_aircraft.screen.VehicleScreenHandler;
import immersive_aircraft.util.Rect2iCommon;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

public class VehicleScreen
extends AbstractContainerScreen<VehicleScreenHandler> {
    private static final ResourceLocation TEXTURE = Main.locate("textures/gui/container/inventory.png");
    public static final int TITLE_HEIGHT = 10;
    public static final int BASE_HEIGHT = 86;
    public int containerSize;

    public VehicleScreen(VehicleScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        this.containerSize = handler.getVehicle().getInventoryDescription().getHeight();
        this.f_97727_ = 86 + this.containerSize + 20;
        this.f_97731_ = this.containerSize + 10;
    }

    protected void m_7286_(@NotNull PoseStack matrices, float delta, int mouseX, int mouseY) {
    }

    protected void drawRectangle(PoseStack matrices, int x, int y, int h, int w) {
        VehicleScreen.m_93133_((PoseStack)matrices, (int)x, (int)y, (float)176.0f, (float)0.0f, (int)16, (int)16, (int)512, (int)256);
        VehicleScreen.m_93133_((PoseStack)matrices, (int)(x + w - 16), (int)y, (float)208.0f, (float)0.0f, (int)16, (int)16, (int)512, (int)256);
        VehicleScreen.m_93133_((PoseStack)matrices, (int)(x + w - 16), (int)(y + h - 16), (float)208.0f, (float)32.0f, (int)16, (int)16, (int)512, (int)256);
        VehicleScreen.m_93133_((PoseStack)matrices, (int)x, (int)(y + h - 16), (float)176.0f, (float)32.0f, (int)16, (int)16, (int)512, (int)256);
        VehicleScreen.m_93160_((PoseStack)matrices, (int)(x + 16), (int)y, (int)(w - 32), (int)16, (float)192.0f, (float)0.0f, (int)16, (int)16, (int)512, (int)256);
        VehicleScreen.m_93160_((PoseStack)matrices, (int)(x + 16), (int)(y + h - 16), (int)(w - 32), (int)16, (float)192.0f, (float)32.0f, (int)16, (int)16, (int)512, (int)256);
        VehicleScreen.m_93160_((PoseStack)matrices, (int)x, (int)(y + 16), (int)16, (int)(h - 32), (float)176.0f, (float)16.0f, (int)16, (int)16, (int)512, (int)256);
        VehicleScreen.m_93160_((PoseStack)matrices, (int)(x + w - 16), (int)(y + 16), (int)16, (int)(h - 32), (float)208.0f, (float)16.0f, (int)16, (int)16, (int)512, (int)256);
        VehicleScreen.m_93160_((PoseStack)matrices, (int)(x + 16), (int)(y + 16), (int)(w - 32), (int)(h - 32), (float)192.0f, (float)16.0f, (int)16, (int)16, (int)512, (int)256);
    }

    protected void drawCustomBackground(PoseStack matrices) {
        this.m_7333_(matrices);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        VehicleScreen.m_93133_((PoseStack)matrices, (int)this.f_97735_, (int)this.f_97736_, (float)0.0f, (float)0.0f, (int)this.f_97726_, (int)(this.containerSize + 20), (int)512, (int)256);
        VehicleScreen.m_93133_((PoseStack)matrices, (int)this.f_97735_, (int)(this.f_97736_ + this.containerSize + 20 - 4), (float)0.0f, (float)136.0f, (int)this.f_97726_, (int)86, (int)512, (int)256);
        for (Rect2iCommon rectangle : ((VehicleScreenHandler)this.f_97732_).getVehicle().getInventoryDescription().getRectangles()) {
            this.drawRectangle(matrices, this.f_97735_ + rectangle.getX(), this.f_97736_ + rectangle.getY(), rectangle.getHeight(), rectangle.getWidth());
        }
    }

    private void drawImage(PoseStack matrices, int x, int y, int u, int v, int w, int h) {
        VehicleScreen.m_93133_((PoseStack)matrices, (int)x, (int)y, (float)u, (float)v, (int)w, (int)h, (int)512, (int)256);
    }

    public void m_6305_(@NotNull PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.drawCustomBackground(matrices);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        int titleHeight = 10;
        block11: for (VehicleInventoryDescription.Slot slot : ((VehicleScreenHandler)this.f_97732_).getVehicle().getInventoryDescription().getSlots()) {
            block0 : switch (slot.type()) {
                case INVENTORY: {
                    this.drawImage(matrices, this.f_97735_ + slot.x() - 1, this.f_97736_ + titleHeight + slot.y() - 1, 284, 0, 18, 18);
                    break;
                }
                case BOILER: {
                    EngineAircraft engineAircraft;
                    this.drawImage(matrices, this.f_97735_ + slot.x() - 4, this.f_97736_ + titleHeight + slot.y() - 18, 318, 0, 24, 39);
                    InventoryVehicleEntity inventoryVehicleEntity = ((VehicleScreenHandler)this.f_97732_).getVehicle();
                    if (!(inventoryVehicleEntity instanceof EngineAircraft) || !((double)(engineAircraft = (EngineAircraft)inventoryVehicleEntity).getFuelUtilization() > 0.0)) continue block11;
                    this.drawImage(matrices, this.f_97735_ + slot.x() - 4, this.f_97736_ + titleHeight + slot.y() - 18, 348, 0, 24, 39);
                    break;
                }
                default: {
                    if (((VehicleScreenHandler)this.f_97732_).getVehicle().getInventory().m_8020_(slot.index()).m_41619_()) {
                        switch (slot.type()) {
                            case WEAPON: {
                                this.drawImage(matrices, this.f_97735_ + slot.x() - 3, this.f_97736_ + titleHeight + slot.y() - 3, 262, 22, 22, 22);
                                break block0;
                            }
                            case UPGRADE: {
                                this.drawImage(matrices, this.f_97735_ + slot.x() - 3, this.f_97736_ + titleHeight + slot.y() - 3, 262, 44, 22, 22);
                                break block0;
                            }
                            case BANNER: {
                                this.drawImage(matrices, this.f_97735_ + slot.x() - 3, this.f_97736_ + titleHeight + slot.y() - 3, 262, 66, 22, 22);
                                break block0;
                            }
                            case DYE: {
                                this.drawImage(matrices, this.f_97735_ + slot.x() - 3, this.f_97736_ + titleHeight + slot.y() - 3, 262, 88, 22, 22);
                                break block0;
                            }
                            case BOOSTER: {
                                this.drawImage(matrices, this.f_97735_ + slot.x() - 3, this.f_97736_ + titleHeight + slot.y() - 3, 262, 110, 22, 22);
                            }
                        }
                        break;
                    }
                    this.drawImage(matrices, this.f_97735_ + slot.x() - 3, this.f_97736_ + titleHeight + slot.y() - 3, 262, 0, 22, 22);
                }
            }
        }
        super.m_6305_(matrices, mouseX, mouseY, delta);
        if (this.f_97734_ != null && !this.f_97734_.m_6657_() && this.f_97734_.f_40218_ == ((VehicleScreenHandler)this.f_97732_).getVehicle().getInventory()) {
            VehicleInventoryDescription.Slot slot = ((VehicleScreenHandler)this.f_97732_).getVehicle().getInventoryDescription().getSlots().get(this.f_97734_.m_150661_());
            if (slot.type() == VehicleInventoryDescription.SlotType.DYE || slot.type() == VehicleInventoryDescription.SlotType.BOOSTER || slot.type() == VehicleInventoryDescription.SlotType.BOILER || slot.type() == VehicleInventoryDescription.SlotType.UPGRADE || slot.type() == VehicleInventoryDescription.SlotType.BANNER || slot.type() == VehicleInventoryDescription.SlotType.WEAPON) {
                this.m_169388_(matrices, List.of(Component.m_237115_((String)("immersive_aircraft.slot." + slot.type().name().toLowerCase(Locale.ROOT)))), Optional.empty(), mouseX, mouseY);
            }
        } else {
            this.m_7025_(matrices, mouseX, mouseY);
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97728_ = (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)this.f_96539_)) / 2;
    }

    protected boolean m_7467_(double mouseX, double mouseY, int left, int top, int button) {
        if (super.m_7467_(mouseX, mouseY, left, top, button)) {
            for (Rect2iCommon rectangle : ((VehicleScreenHandler)this.f_97732_).getVehicle().getInventoryDescription().getRectangles()) {
                if (!(mouseX > (double)(rectangle.getX() + this.f_97735_)) || !(mouseX < (double)(rectangle.getX() + rectangle.getWidth() + this.f_97735_)) || !(mouseY > (double)(rectangle.getY() + this.f_97736_)) || !(mouseY < (double)(rectangle.getY() + rectangle.getHeight() + this.f_97736_))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int getX() {
        return this.f_97735_;
    }

    public int getY() {
        return this.f_97736_;
    }
}

