/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco.blocks;

import com.simibubi.create.foundation.placement.IPlacementHelper;
import com.simibubi.create.foundation.placement.PlacementHelpers;
import com.simibubi.create.foundation.placement.PlacementOffset;
import com.simibubi.create.foundation.placement.PoleHelper;
import java.util.function.Predicate;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SupportBlock
extends DirectionalBlock
implements SimpleWaterloggedBlock {
    private static final VoxelShape NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    private static final VoxelShape SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape UP = Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape DOWN = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    private static final VoxelShape X = Shapes.m_83113_((VoxelShape)EAST, (VoxelShape)WEST, (BooleanOp)BooleanOp.f_82695_);
    private static final VoxelShape Y = Shapes.m_83113_((VoxelShape)UP, (VoxelShape)DOWN, (BooleanOp)BooleanOp.f_82695_);
    private static final VoxelShape Z = Shapes.m_83113_((VoxelShape)NORTH, (VoxelShape)SOUTH, (BooleanOp)BooleanOp.f_82695_);
    private static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());

    public SupportBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_52588_});
        builder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        ItemStack heldItem = player.m_21120_(hand);
        IPlacementHelper placementHelper = PlacementHelpers.get((int)placementHelperId);
        if (!placementHelper.matchesItem(heldItem)) {
            return InteractionResult.PASS;
        }
        return placementHelper.getOffset(player, world, state, pos, ray).placeInWorld(world, (BlockItem)heldItem.m_41720_(), player, hand, ray);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        FluidState fluid = ctx.m_43725_().m_6425_(ctx.m_8083_());
        BlockState result = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_52588_, (Comparable)ctx.m_43719_())).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(fluid.m_192917_((Fluid)Fluids.f_76193_)));
        return result;
    }

    public boolean m_6044_(BlockGetter world, BlockPos pos, BlockState state, Fluid fluid) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) == false && fluid == Fluids.f_76193_;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext ctx) {
        return Shapes.m_83040_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext ctx) {
        return switch (((Direction)state.m_61143_((Property)f_52588_)).m_122434_()) {
            case Direction.Axis.X -> Shapes.m_83113_((VoxelShape)Y, (VoxelShape)Z, (BooleanOp)BooleanOp.f_82695_);
            case Direction.Axis.Z -> Shapes.m_83113_((VoxelShape)X, (VoxelShape)Y, (BooleanOp)BooleanOp.f_82695_);
            default -> Shapes.m_83113_((VoxelShape)X, (VoxelShape)Z, (BooleanOp)BooleanOp.f_82695_);
        };
    }

    public static boolean isSupportBlock(ItemStack test) {
        return test.m_41720_() instanceof BlockItem && SupportBlock.isSupportBlock(((BlockItem)test.m_41720_()).m_40614_());
    }

    public static boolean isSupportBlock(Block test) {
        return test instanceof SupportBlock;
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    extends PoleHelper<Direction> {
        public PlacementHelper() {
            super(state -> SupportBlock.isSupportBlock(state.m_60734_()), state -> ((Direction)state.m_61143_((Property)f_52588_)).m_122434_(), (Property)f_52588_);
        }

        public Predicate<ItemStack> getItemPredicate() {
            return SupportBlock::isSupportBlock;
        }

        public Predicate<BlockState> getStatePredicate() {
            return state -> SupportBlock.isSupportBlock(state.m_60734_());
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            PlacementOffset offset = super.getOffset(player, world, state, pos, ray);
            offset.withTransform(offset.getTransform());
            return offset;
        }
    }
}

