/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.parts.anim.menu;

import com.tom.cpl.nbt.NBTTagCompound;
import com.tom.cpm.shared.config.PlayerData;
import com.tom.cpm.shared.parts.anim.menu.BitmaskParameterValueAction;
import com.tom.cpm.shared.parts.anim.menu.SimpleParameterValueAction;
import com.tom.cpm.shared.parts.anim.menu.ValueParameterValueAction;
import java.util.Locale;

public interface CommandAction {
    public String getName();

    public void write(NBTTagCompound var1);

    public ActionType getType();

    public int getValue();

    public void setValue(int var1);

    public int getMaxValue();

    public boolean isCommandControlled();

    public static NBTTagCompound serialize(CommandAction action) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.setString("type", action.getType().name().toLowerCase(Locale.ROOT));
        tag.setString("name", action.getName());
        action.write(tag);
        return tag;
    }

    public static enum ActionType {
        SIMPLE(SimpleParameterValueAction.ServerAction::new),
        BITMASK(BitmaskParameterValueAction.ServerAction::new),
        VALUE(ValueParameterValueAction.ServerAction::new);

        public ActionTypeFactory factory;

        private ActionType(ActionTypeFactory factory) {
            this.factory = factory;
        }

        public static ServerCommandAction make(NBTTagCompound tag, PlayerData data) {
            String t = tag.getString("type");
            for (ActionType at : ActionType.values()) {
                if (!at.name().equalsIgnoreCase(t)) continue;
                return at.factory.create(tag.getString("name"), tag, data);
            }
            return null;
        }
    }

    public static interface ActionTypeFactory {
        public ServerCommandAction create(String var1, NBTTagCompound var2, PlayerData var3);
    }

    public static interface LegacyCommandActionWriter {
        public void writeLegacy(NBTTagCompound var1);
    }

    public static interface ServerCommandAction {
        public String getName();

        public int getValue();

        public boolean isCommandControlled();
    }
}

