/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.common;

import com.tom.cpl.block.BlockState;
import com.tom.cpl.block.BlockStateHandler;
import com.tom.cpl.item.Stack;
import com.tom.cpm.common.ItemStackHandlerImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockStateHandlerImpl
extends BlockStateHandler<net.minecraft.world.level.block.state.BlockState> {
    public static final BlockStateHandlerImpl impl = new BlockStateHandlerImpl();

    @Override
    public String getBlockId(net.minecraft.world.level.block.state.BlockState stack) {
        return Registry.f_122824_.m_7981_((Object)stack.m_60734_()).toString();
    }

    @Override
    public List<String> getBlockStates(net.minecraft.world.level.block.state.BlockState stack) {
        return stack.m_61147_().stream().map(p -> p.m_61708_()).toList();
    }

    private Stream<Map.Entry<Property<?>, Comparable<?>>> getProp(net.minecraft.world.level.block.state.BlockState state, String property) {
        return state.m_61148_().entrySet().stream().filter(e -> ((Property)e.getKey()).m_61708_().equals(property));
    }

    @Override
    public String getPropertyValue(net.minecraft.world.level.block.state.BlockState state, String property) {
        return this.getProp(state, property).map(this::propValue).findFirst().orElse(null);
    }

    private String propValue(Map.Entry<Property<?>, Comparable<?>> e) {
        Property<?> p = e.getKey();
        return p.m_6940_(e.getValue());
    }

    @Override
    public int getPropertyValueInt(net.minecraft.world.level.block.state.BlockState state, String property) {
        return this.getProp(state, property).mapToInt(e -> {
            int n;
            Comparable patt1792$temp = state.m_61143_((Property)e.getKey());
            if (patt1792$temp instanceof Number) {
                Number n2 = (Number)((Object)patt1792$temp);
                n = n2.intValue();
            } else {
                n = -1;
            }
            return n;
        }).findFirst().orElse(-1);
    }

    @Override
    public List<String> getAllValuesFor(net.minecraft.world.level.block.state.BlockState state, String property) {
        return this.getProp(state, property).flatMap(e -> ((Property)e.getKey()).m_6908_().stream().map(v -> {
            Property p = (Property)e.getKey();
            return p.m_6940_(v);
        })).toList();
    }

    @Override
    public List<String> listTags(net.minecraft.world.level.block.state.BlockState stack) {
        return stack.m_222976_().m_203616_().map(k -> "#" + k.f_203868_()).toList();
    }

    @Override
    public List<BlockState> listNativeEntries(String tag) {
        ArrayList<BlockState> stacks = new ArrayList<BlockState>();
        if (tag.charAt(0) == '#') {
            ResourceLocation rl = ResourceLocation.m_135820_((String)tag.substring(1));
            if (rl != null) {
                TagKey i = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)rl);
                Registry.f_122824_.m_203431_(i).map(t -> t.m_203614_().map(h -> h.m_203439_().right()).filter(Optional::isPresent).map(o -> this.wrap(((Block)o.get()).m_49966_())).toList()).ifPresent(stacks::addAll);
            }
        } else {
            ResourceLocation rl = ResourceLocation.m_135820_((String)tag);
            Block item = (Block)Registry.f_122824_.m_7745_(rl);
            if (item != null) {
                stacks.add(this.wrap(item.m_49966_()));
            }
        }
        return stacks;
    }

    @Override
    public List<String> listNativeTags() {
        return Registry.f_122824_.m_203613_().map(k -> k.f_203868_().toString()).toList();
    }

    @Override
    public List<BlockState> getAllElements() {
        return Registry.f_122824_.m_123024_().map(b -> this.wrap(b.m_49966_())).toList();
    }

    @Override
    public boolean isInTag(String tag, net.minecraft.world.level.block.state.BlockState stack) {
        if (tag.charAt(0) == '#') {
            ResourceLocation rl = ResourceLocation.m_135820_((String)tag.substring(1));
            if (rl != null) {
                TagKey i = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)rl);
                return stack.m_204336_(i);
            }
        } else {
            return this.getBlockId(stack).equals(tag);
        }
        return false;
    }

    @Override
    public boolean equals(net.minecraft.world.level.block.state.BlockState a, net.minecraft.world.level.block.state.BlockState b) {
        return a.m_60734_() == b.m_60734_();
    }

    @Override
    public Stack getStackFromState(net.minecraft.world.level.block.state.BlockState state) {
        return ItemStackHandlerImpl.impl.wrap(new ItemStack((ItemLike)state.m_60734_()));
    }

    @Override
    public boolean equalsFull(net.minecraft.world.level.block.state.BlockState a, net.minecraft.world.level.block.state.BlockState b) {
        return a.equals(b);
    }

    @Override
    public BlockState emptyObject() {
        return this.wrap(Blocks.f_50016_.m_49966_());
    }
}

