/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.common;

import com.tom.cpm.common.PlatformCommon;
import com.tom.cpm.shared.network.NetHandler;
import com.tom.cpm.shared.util.ScalingOptions;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class AttributeScaler
implements NetHandler.ScalerInterface<ServerPlayer, List<Attribute>> {
    private static final UUID CPM_ATTR_UUID = UUID.fromString("24bba381-9615-4530-8fcf-4fc42393a4b5");

    @Override
    public void setScale(List<Attribute> key, ServerPlayer player, float value) {
        key.forEach(a -> {
            AttributeInstance ai = player.m_21204_().m_22146_(a);
            if (ai != null) {
                ai.m_22120_(CPM_ATTR_UUID);
                if (Math.abs(value - 1.0f) > 0.01f) {
                    ai.m_22118_(new AttributeModifier(CPM_ATTR_UUID, "cpm", (double)(value - 1.0f), AttributeModifier.Operation.MULTIPLY_BASE));
                }
            }
        });
    }

    @Override
    public List<Attribute> toKey(ScalingOptions opt) {
        switch (opt) {
            case HEALTH: {
                return Collections.singletonList(Attributes.f_22276_);
            }
            case ATTACK_DMG: {
                return Collections.singletonList(Attributes.f_22281_);
            }
            case ATTACK_KNOCKBACK: {
                return Collections.singletonList(Attributes.f_22282_);
            }
            case ATTACK_SPEED: {
                return Collections.singletonList(Attributes.f_22283_);
            }
            case DEFENSE: {
                return Collections.singletonList(Attributes.f_22284_);
            }
            case MOB_VISIBILITY: {
                return Collections.singletonList(Attributes.f_22277_);
            }
            case MOTION: {
                return Collections.singletonList(Attributes.f_22279_);
            }
            case KNOCKBACK_RESIST: {
                return Collections.singletonList(Attributes.f_22278_);
            }
            case REACH: {
                return PlatformCommon.getReachAttr();
            }
            case STEP_HEIGHT: {
                return PlatformCommon.getStepHeightAttr();
            }
        }
        return null;
    }

    @Override
    public String getMethodName() {
        return "attribute";
    }
}

