/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Mat4f;
import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.render.RenderTypes;
import com.tom.cpl.render.VBuffers;
import com.tom.cpl.util.Image;
import com.tom.cpm.client.GuiBase;
import com.tom.cpm.client.MinecraftObject;
import com.tom.cpm.client.VBuffer;
import com.tom.cpm.shared.gui.ViewportCamera;
import com.tom.cpm.shared.gui.panel.Panel3d;
import com.tom.cpm.shared.model.render.RenderMode;
import java.nio.FloatBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class Panel3dImpl
extends Panel3d.Panel3dNative {
    private PoseStack matrixstack;
    private Minecraft mc = Minecraft.m_91087_();

    public Panel3dImpl(Panel3d panel) {
        super(panel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(float partialTicks) {
        ViewportCamera cam = this.panel.getCamera();
        float pitch = (float)Math.asin(cam.look.y);
        float yaw = cam.look.getYaw();
        Box bounds = this.getBounds();
        Vec2i off = this.panel.getGui().getOffset();
        float size = cam.camDist;
        PoseStack matrixStack = RenderSystem.m_157191_();
        matrixStack.m_85836_();
        try {
            matrixStack.m_85837_((double)(off.x + bounds.w / 2), (double)(off.y + bounds.h / 2), 600.0);
            matrixStack.m_85841_(1.0f, 1.0f, -0.1f);
            RenderSystem.m_157182_();
            this.matrixstack = new PoseStack();
            this.matrixstack.m_85837_(0.0, 0.0, 1000.0);
            this.matrixstack.m_85841_(size, size, size);
            Quaternion quaternion = Vector3f.f_122227_.m_122240_(180.0f);
            Quaternion quaternion1 = Vector3f.f_122223_.m_122270_(-pitch);
            quaternion.m_80148_(quaternion1);
            this.matrixstack.m_85845_(quaternion);
            this.matrixstack.m_85845_(Vector3f.f_122225_.m_122270_((float)((double)yaw + Math.PI)));
            this.matrixstack.m_85837_((double)(-cam.position.x), (double)(-cam.position.y), (double)(-cam.position.z));
            RenderSystem.m_69482_();
            MultiBufferSource.BufferSource bufs = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            int light = LightTexture.m_109885_((int)15, (int)15);
            this.panel.render(new MatrixStack(), new VBuffers(rt -> new VBuffer(bufs.m_6299_((RenderType)rt.getNativeType()), light, OverlayTexture.f_118083_, this.matrixstack)), partialTicks);
            bufs.m_109911_();
        }
        finally {
            RenderSystem.m_69465_();
            matrixStack = RenderSystem.m_157191_();
            matrixStack.m_85849_();
            RenderSystem.m_157182_();
            this.matrixstack = null;
        }
    }

    @Override
    public RenderTypes<RenderMode> getRenderTypes() {
        return this.getRenderTypes0(MinecraftObject.DynTexture.getBoundLoc());
    }

    @Override
    public RenderTypes<RenderMode> getRenderTypes(String texture) {
        return this.getRenderTypes0(new ResourceLocation("cpm", "textures/gui/" + texture + ".png"));
    }

    @Override
    public Image takeScreenshot(Vec2i size) {
        GuiBase gui = (GuiBase)this.panel.getGui().getNativeGui();
        int dw = this.mc.m_91268_().m_85441_();
        int dh = this.mc.m_91268_().m_85442_();
        float multiplierX = (float)dw / (float)gui.f_96543_;
        float multiplierY = (float)dh / (float)gui.f_96544_;
        int width = (int)(multiplierX * (float)size.x);
        int height = (int)(multiplierY * (float)size.y);
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)(width * height * 3));
        GL11.glReadPixels((int)((int)(multiplierX * (float)this.renderPos.x)), (int)(this.mc.m_91268_().m_85442_() - height - (int)(multiplierY * (float)this.renderPos.y)), (int)width, (int)height, (int)6407, (int)5126, (FloatBuffer)buffer);
        Image img = new Image(width, height);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                float r = buffer.get((x + y * width) * 3);
                float g = buffer.get((x + y * width) * 3 + 1);
                float b = buffer.get((x + y * width) * 3 + 2);
                int color = 0xFF000000 | (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f);
                img.setRGB(x, height - y - 1, color);
            }
        }
        Image rImg = new Image(size.x, size.y);
        rImg.draw(img, 0, 0, size.x, size.y);
        return rImg;
    }

    @Override
    public Mat4f getView() {
        return Mat4f.map(RenderSystem.m_157190_(), this.matrixstack.m_85850_().m_85861_(), Matrix4f::m_27650_);
    }

    @Override
    public Mat4f getProjection() {
        return Mat4f.map(RenderSystem.m_157192_(), Matrix4f::m_27650_);
    }
}

