/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.api;

import com.tom.cpl.nbt.NBTTagCompound;
import com.tom.cpm.api.ISharedAPI;
import com.tom.cpm.shared.animation.AnimationEngine;
import com.tom.cpm.shared.animation.AnimationState;
import com.tom.cpm.shared.editor.gui.EditorGui;
import com.tom.cpm.shared.retro.RetroPlayerRendererImpl;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public interface IClientAPI
extends ISharedAPI {
    public <T> void registerVoice(Class<T> var1, Function<T, Float> var2);

    public void registerVoice(Function<UUID, Float> var1);

    public <T> void registerVoiceMute(Class<T> var1, Predicate<T> var2);

    public void registerVoiceMute(Predicate<UUID> var1);

    public <M, RL, RT, MBS, GP> PlayerRenderer<M, RL, RT, MBS, GP> createPlayerRenderer(Class<M> var1, Class<RL> var2, Class<RT> var3, Class<MBS> var4, Class<GP> var5);

    public LocalModel loadModel(String var1, InputStream var2) throws IOException;

    public void registerEditorGenerator(String var1, String var2, Consumer<EditorGui> var3);

    public <P> MessageSender registerPluginMessage(Class<P> var1, String var2, BiConsumer<P, NBTTagCompound> var3, boolean var4);

    public MessageSender registerPluginMessage(String var1, BiConsumer<UUID, NBTTagCompound> var2, boolean var3);

    public <P> MessageSender registerPluginStateMessage(Class<P> var1, String var2, BiConsumer<P, NBTTagCompound> var3);

    public MessageSender registerPluginStateMessage(String var1, BiConsumer<UUID, NBTTagCompound> var2);

    default public <M, GP> RetroPlayerRenderer<M, GP> createPlayerRenderer(Class<M> modelClass, Class<GP> gameProfileClass) {
        return new RetroPlayerRendererImpl<M, GP>(this.createPlayerRenderer(modelClass, Void.class, Void.class, Void.class, gameProfileClass));
    }

    public boolean playAnimation(String var1, int var2);

    public boolean playAnimation(String var1);

    public int getAnimationPlaying(String var1);

    public int getAnimationMaxValue(String var1);

    public static interface PlayerRenderer<M, RL, RT, MBS, GP> {
        public void setGameProfile(GP var1);

        public void setLocalModel(LocalModel var1);

        public void setRenderModel(M var1);

        public void setRenderType(Function<RL, RT> var1);

        public RT getDefaultRenderType();

        public RL getDefaultTexture();

        public RT getRenderTypeForSubModel(M var1);

        public AnimationState getAnimationState();

        public void preRender(MBS var1, AnimationEngine.AnimationMode var2);

        public void prepareSubModel(M var1, SubModelType var2, RL var3);

        public void postRender();

        public void setActivePose(String var1);

        public void setActiveGesture(String var1);
    }

    public static enum SubModelType {
        ARMOR_OUTER,
        ARMOR_INNER,
        ELYTRA,
        CAPE;

    }

    public static interface LocalModel {
        public <GP> GP getGameProfile();

        public void startRender();

        public String getUniqueKey();
    }

    public static interface RetroPlayerRenderer<M, GP> {
        public void setGameProfile(GP var1);

        public void setLocalModel(LocalModel var1);

        public void setRenderModel(M var1);

        public AnimationState getAnimationState();

        public void preRender(AnimationEngine.AnimationMode var1);

        public void prepareSubModel(M var1, SubModelType var2);

        public void postRender();

        public void setActivePose(String var1);

        public void setActiveGesture(String var1);
    }

    @FunctionalInterface
    public static interface MessageSender {
        public boolean sendMessage(NBTTagCompound var1);
    }
}

