/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.gui.util;

import com.tom.cpl.gui.elements.GuiElement;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.math.Box;
import java.util.List;

public class FlowLayout
implements Runnable {
    private Panel panel;
    private int padding;
    private int direction;
    private int size;

    public FlowLayout(Panel panel, int padding, int direction) {
        this.panel = panel;
        this.padding = padding;
        this.direction = direction;
    }

    public void reflow() {
        if (this.direction == 0) {
            List<GuiElement> elements = this.panel.getElements();
            int space = (this.size - this.padding) / elements.size();
            for (int i = 0; i < elements.size(); ++i) {
                GuiElement e = elements.get(i);
                Box b = e.getBounds();
                e.setBounds(new Box(i * space + this.padding, b.y, space - this.padding, b.h));
            }
        } else {
            List<GuiElement> elements = this.panel.getElements();
            int h = 0;
            for (int i = 0; i < elements.size(); ++i) {
                GuiElement e = elements.get(i);
                if (!e.isVisible()) continue;
                Box b = e.getBounds();
                e.setBounds(new Box(b.x, h, b.w, b.h));
                h += b.h;
                h += this.padding;
            }
            Box b = this.panel.getBounds();
            this.panel.setBounds(new Box(b.x, b.y, b.w, h));
        }
    }

    public void setSize(int size) {
        this.size = size;
        this.reflow();
    }

    @Override
    public void run() {
        this.reflow();
    }
}

