/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.volume;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.volume.AdjustVolumeSlider;
import de.maxhenkel.voicechat.gui.volume.AdjustVolumesScreen;
import de.maxhenkel.voicechat.gui.volume.VolumeEntry;
import de.maxhenkel.voicechat.plugins.impl.VolumeCategoryImpl;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;

public class CategoryVolumeEntry
extends VolumeEntry {
    protected final VolumeCategoryImpl category;
    protected final ResourceLocation texture;

    public CategoryVolumeEntry(VolumeCategoryImpl category, AdjustVolumesScreen screen) {
        super(screen, new AdjustCategoryVolumeEntry(category.getId()));
        this.category = category;
        this.texture = ClientManager.getCategoryManager().getTexture(category.getId(), OTHER_VOLUME_ICON);
    }

    public VolumeCategoryImpl getCategory() {
        return this.category;
    }

    @Override
    public void renderElement(PoseStack poseStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float delta, int skinX, int skinY, int textX, int textY) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.texture);
        GuiComponent.m_93160_((PoseStack)poseStack, (int)skinX, (int)skinY, (int)24, (int)24, (float)16.0f, (float)16.0f, (int)16, (int)16, (int)16, (int)16);
        this.minecraft.f_91062_.m_92889_(poseStack, this.category.getDisplayName(), (float)textX, (float)textY, PLAYER_NAME_COLOR);
        if (hovered && this.category.getDescription() != null) {
            this.screen.postRender(() -> this.screen.m_96602_(poseStack, this.category.getDisplayDescription(), mouseX, mouseY));
        }
    }

    private static class AdjustCategoryVolumeEntry
    implements AdjustVolumeSlider.AdjustVolumeEntry {
        private final String category;

        public AdjustCategoryVolumeEntry(String category) {
            this.category = category;
        }

        @Override
        public void save(double value) {
            VoicechatClient.CATEGORY_VOLUME_CONFIG.setVolume(this.category, value, new String[0]);
            VoicechatClient.CATEGORY_VOLUME_CONFIG.save();
        }

        @Override
        public double get() {
            return VoicechatClient.CATEGORY_VOLUME_CONFIG.getVolume(this.category);
        }

        @Override
        public double getAudioLevel() {
            ClientVoicechat client = ClientManager.getClient();
            if (client == null) {
                return -127.0;
            }
            return client.getTalkCache().getCategoryAudioLevel(this.category);
        }
    }
}

