/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.sound.held;

import com.cstav.genshinstrument.networking.GIPacketHandler;
import com.cstav.genshinstrument.networking.buttonidentifier.NoteButtonIdentifier;
import com.cstav.genshinstrument.networking.packet.instrument.NoteSoundMetadata;
import com.cstav.genshinstrument.networking.packet.instrument.c2s.C2SHeldNoteSoundPacket;
import com.cstav.genshinstrument.networking.packet.instrument.util.HeldSoundPhase;
import com.cstav.genshinstrument.sound.held.HeldNoteSound;
import com.cstav.genshinstrument.sound.held.HeldNoteSoundInstance;
import com.cstav.genshinstrument.sound.held.InitiatorID;
import com.cstav.genshinstrument.util.MultTuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class HeldNoteSounds {
    private static final Map<InitiatorID, Map<HeldNoteSound, Map<Integer, List<HeldNoteSoundInstance>>>> SOUND_INSTANCES = new HashMap<InitiatorID, Map<HeldNoteSound, Map<Integer, List<HeldNoteSoundInstance>>>>();

    public static void put(InitiatorID initiatorId, HeldNoteSound key, int notePitch, HeldNoteSoundInstance soundInstance) {
        SOUND_INSTANCES.computeIfAbsent(initiatorId, _k -> new HashMap()).computeIfAbsent(key, _k -> new HashMap()).computeIfAbsent(notePitch, _k -> new ArrayList()).add(soundInstance);
    }

    public static boolean hasInstances(HeldNoteSound sound) {
        return SOUND_INSTANCES.values().stream().anyMatch(k2p2i -> k2p2i.containsKey(sound));
    }

    public static Collection<HeldNoteSoundInstance> getUnique(List<HeldNoteSoundInstance> sounds) {
        return sounds.stream().collect(Collectors.toMap(sound -> new MultTuple(sound.heldSoundContainer, sound.instrumentId, sound.notePitch), Function.identity(), (curr, repl) -> curr)).values();
    }

    public static void notifyRelease(HeldNoteSoundInstance soundInstance, @Nullable NoteButtonIdentifier noteIdentifier) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        GIPacketHandler.sendToServer(new C2SHeldNoteSoundPacket(soundInstance.heldSoundContainer, new NoteSoundMetadata(player.m_20183_(), soundInstance.notePitch, (int)(soundInstance.m_7769_() * 100.0f), soundInstance.instrumentId, Optional.ofNullable(noteIdentifier)), HeldSoundPhase.RELEASE));
    }

    private static void releaseNAdd(List<HeldNoteSoundInstance> instances, List<HeldNoteSoundInstance> toAdd) {
        instances.forEach(HeldNoteSoundInstance::setReleased);
        toAdd.addAll(instances);
    }

    public static List<HeldNoteSoundInstance> releaseAll() {
        ArrayList released = new ArrayList();
        SOUND_INSTANCES.values().forEach(k2p2i -> k2p2i.values().forEach(p2i -> p2i.values().forEach(instances -> HeldNoteSounds.releaseNAdd(instances, released))));
        SOUND_INSTANCES.clear();
        return Collections.unmodifiableList(released);
    }

    public static List<HeldNoteSoundInstance> release(InitiatorID initiatorId) {
        if (!SOUND_INSTANCES.containsKey(initiatorId)) {
            return List.of();
        }
        ArrayList released = new ArrayList();
        SOUND_INSTANCES.get(initiatorId).values().forEach(p2i -> p2i.values().forEach(instances -> HeldNoteSounds.releaseNAdd(instances, released)));
        SOUND_INSTANCES.remove(initiatorId);
        return Collections.unmodifiableList(released);
    }

    public static List<HeldNoteSoundInstance> release(InitiatorID initiatorId, HeldNoteSound sound) {
        if (!SOUND_INSTANCES.containsKey(initiatorId)) {
            return List.of();
        }
        Map<HeldNoteSound, Map<Integer, List<HeldNoteSoundInstance>>> k2p2i = SOUND_INSTANCES.get(initiatorId);
        if (!k2p2i.containsKey(sound)) {
            return List.of();
        }
        ArrayList released = new ArrayList();
        k2p2i.get(sound).values().forEach(instances -> HeldNoteSounds.releaseNAdd(instances, released));
        k2p2i.remove(sound);
        return Collections.unmodifiableList(released);
    }

    public static List<HeldNoteSoundInstance> release(InitiatorID initiatorId, HeldNoteSound sound, int notePitch) {
        if (!SOUND_INSTANCES.containsKey(initiatorId)) {
            return List.of();
        }
        Map<HeldNoteSound, Map<Integer, List<HeldNoteSoundInstance>>> k2p2i = SOUND_INSTANCES.get(initiatorId);
        if (!k2p2i.containsKey(sound)) {
            return List.of();
        }
        Map<Integer, List<HeldNoteSoundInstance>> p2i = k2p2i.get(sound);
        if (!p2i.containsKey(notePitch)) {
            return List.of();
        }
        ArrayList<HeldNoteSoundInstance> released = new ArrayList<HeldNoteSoundInstance>();
        HeldNoteSounds.releaseNAdd(p2i.get(notePitch), released);
        p2i.remove(notePitch);
        if (p2i.isEmpty()) {
            k2p2i.remove(sound);
        }
        return Collections.unmodifiableList(released);
    }

    public static List<HeldNoteSoundInstance> release(InitiatorID initiatorId, HeldNoteSound sound, int notePitch, HeldNoteSoundInstance soundInstance) {
        if (!SOUND_INSTANCES.containsKey(initiatorId)) {
            return List.of();
        }
        Map<HeldNoteSound, Map<Integer, List<HeldNoteSoundInstance>>> k2p2i = SOUND_INSTANCES.get(initiatorId);
        if (!k2p2i.containsKey(sound)) {
            return List.of();
        }
        Map<Integer, List<HeldNoteSoundInstance>> p2i = k2p2i.get(sound);
        if (!p2i.containsKey(notePitch)) {
            return List.of();
        }
        List<HeldNoteSoundInstance> heldSoundInstances = p2i.get(notePitch);
        heldSoundInstances.remove((Object)soundInstance);
        return List.of(soundInstance);
    }
}

