/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.networking.buttonidentifier;

import com.cstav.genshinstrument.client.gui.screen.instrument.drum.DrumButtonType;
import com.cstav.genshinstrument.client.gui.screen.instrument.drum.DrumNoteButton;
import com.cstav.genshinstrument.networking.buttonidentifier.NoteButtonIdentifier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DrumNoteIdentifier
extends NoteButtonIdentifier {
    public final DrumButtonType noteType;
    public final boolean isRight;

    @OnlyIn(value=Dist.CLIENT)
    public DrumNoteIdentifier(DrumNoteButton note) {
        this.noteType = note.btnType;
        this.isRight = note.isRight;
    }

    public DrumNoteIdentifier(FriendlyByteBuf buf) {
        this.noteType = (DrumButtonType)buf.m_130066_(DrumButtonType.class);
        this.isRight = buf.readBoolean();
    }

    @Override
    public void writeToNetwork(FriendlyByteBuf buf) {
        super.writeToNetwork(buf);
        buf.m_130068_((Enum)this.noteType);
        buf.writeBoolean(this.isRight);
    }

    @Override
    public boolean matches(NoteButtonIdentifier other) {
        return NoteButtonIdentifier.MatchType.forceMatch(other, this::drumMatch);
    }

    private boolean drumMatch(DrumNoteIdentifier other) {
        return this.noteType == other.noteType && this.isRight == other.isRight;
    }
}

