/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.widget.copied;

import com.cstav.genshinstrument.client.gui.widget.copied.AbstractContainerWidget;
import com.cstav.genshinstrument.client.gui.widget.copied.Divisor;
import com.cstav.genshinstrument.client.gui.widget.copied.LayoutSettings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LinearLayoutWidget
extends AbstractContainerWidget {
    private final Orientation orientation;
    private final List<ChildContainer> children = new ArrayList<ChildContainer>();
    private final List<AbstractWidget> containedChildrenView = Collections.unmodifiableList(Lists.transform(this.children, p_254146_ -> p_254146_.child));
    private final LayoutSettings defaultChildLayoutSettings = LayoutSettings.defaults();

    public LinearLayoutWidget(int pWidth, int pHeight, Orientation pOrientation) {
        this(0, 0, pWidth, pHeight, pOrientation);
    }

    public LinearLayoutWidget(int pX, int pY, int pWidth, int pHeight, Orientation pOrientation) {
        super(pX, pY, pWidth, pHeight, (Component)Component.m_237119_());
        this.orientation = pOrientation;
    }

    public void pack() {
        if (!this.children.isEmpty()) {
            int i = 0;
            int j = this.orientation.getSecondaryLength(this);
            for (ChildContainer linearlayoutwidget$childcontainer : this.children) {
                i += this.orientation.getPrimaryLength(linearlayoutwidget$childcontainer);
                j = Math.max(j, this.orientation.getSecondaryLength(linearlayoutwidget$childcontainer));
            }
            int k = this.orientation.getPrimaryLength(this) - i;
            int l = this.orientation.getPrimaryPosition(this);
            Iterator<ChildContainer> iterator = this.children.iterator();
            ChildContainer linearlayoutwidget$childcontainer1 = iterator.next();
            this.orientation.setPrimaryPosition(linearlayoutwidget$childcontainer1, l);
            l += this.orientation.getPrimaryLength(linearlayoutwidget$childcontainer1);
            if (this.children.size() >= 2) {
                Divisor divisor = new Divisor(k, this.children.size() - 1);
                while (divisor.hasNext()) {
                    ChildContainer linearlayoutwidget$childcontainer2 = iterator.next();
                    this.orientation.setPrimaryPosition(linearlayoutwidget$childcontainer2, l += divisor.nextInt());
                    l += this.orientation.getPrimaryLength(linearlayoutwidget$childcontainer2);
                }
            }
            int i1 = this.orientation.getSecondaryPosition(this);
            for (ChildContainer linearlayoutwidget$childcontainer3 : this.children) {
                this.orientation.setSecondaryPosition(linearlayoutwidget$childcontainer3, i1, j);
            }
            this.orientation.setSecondaryLength(this, j);
        }
    }

    @Override
    public List<? extends AbstractWidget> getContainedChildren() {
        return this.containedChildrenView;
    }

    public LayoutSettings newChildLayoutSettings() {
        return this.defaultChildLayoutSettings.copy();
    }

    public LayoutSettings defaultChildLayoutSetting() {
        return this.defaultChildLayoutSettings;
    }

    public <T extends AbstractWidget> T addChild(T pChild) {
        return this.addChild(pChild, this.newChildLayoutSettings());
    }

    public <T extends AbstractWidget> T addChild(T pChild, LayoutSettings pLayoutSettings) {
        this.children.add(new ChildContainer(pChild, pLayoutSettings));
        return pChild;
    }

    public void m_142291_(NarrationElementOutput pNarrationElementOutput) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum Orientation {
        HORIZONTAL,
        VERTICAL;


        int getPrimaryLength(AbstractWidget pWidget) {
            return switch (this) {
                case HORIZONTAL -> pWidget.m_5711_();
                case VERTICAL -> pWidget.m_93694_();
                default -> throw new IncompatibleClassChangeError();
            };
        }

        int getPrimaryLength(ChildContainer pContainer) {
            return switch (this) {
                case HORIZONTAL -> pContainer.getWidth();
                case VERTICAL -> pContainer.getHeight();
                default -> throw new IncompatibleClassChangeError();
            };
        }

        int getSecondaryLength(AbstractWidget pWidget) {
            return switch (this) {
                case HORIZONTAL -> pWidget.m_93694_();
                case VERTICAL -> pWidget.m_5711_();
                default -> throw new IncompatibleClassChangeError();
            };
        }

        int getSecondaryLength(ChildContainer pContainer) {
            return switch (this) {
                case HORIZONTAL -> pContainer.getHeight();
                case VERTICAL -> pContainer.getWidth();
                default -> throw new IncompatibleClassChangeError();
            };
        }

        void setPrimaryPosition(ChildContainer pContainer, int pPosition) {
            switch (this) {
                case HORIZONTAL: {
                    pContainer.setX(pPosition, pContainer.getWidth());
                    break;
                }
                case VERTICAL: {
                    pContainer.setY(pPosition, pContainer.getHeight());
                }
            }
        }

        void setSecondaryPosition(ChildContainer pContainer, int pPosition, int pSize) {
            switch (this) {
                case HORIZONTAL: {
                    pContainer.setY(pPosition, pSize);
                    break;
                }
                case VERTICAL: {
                    pContainer.setX(pPosition, pSize);
                }
            }
        }

        int getPrimaryPosition(AbstractWidget pWidget) {
            return switch (this) {
                case HORIZONTAL -> pWidget.f_93620_;
                case VERTICAL -> pWidget.f_93621_;
                default -> throw new IncompatibleClassChangeError();
            };
        }

        int getSecondaryPosition(AbstractWidget pWidget) {
            return switch (this) {
                case HORIZONTAL -> pWidget.f_93621_;
                case VERTICAL -> pWidget.f_93620_;
                default -> throw new IncompatibleClassChangeError();
            };
        }

        void setSecondaryLength(AbstractWidget pWidget, int pLength) {
            switch (this) {
                case HORIZONTAL: {
                    pWidget.setHeight(pLength);
                    break;
                }
                case VERTICAL: {
                    pWidget.m_93674_(pLength);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class ChildContainer
    extends AbstractContainerWidget.AbstractChildWrapper {
        protected ChildContainer(AbstractWidget p_253998_, LayoutSettings p_254445_) {
            super(p_253998_, p_254445_);
        }
    }
}

