/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.widget.copied;

import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public interface LayoutSettings {
    public LayoutSettings padding(int var1);

    public LayoutSettings padding(int var1, int var2);

    public LayoutSettings padding(int var1, int var2, int var3, int var4);

    public LayoutSettings paddingLeft(int var1);

    public LayoutSettings paddingTop(int var1);

    public LayoutSettings paddingRight(int var1);

    public LayoutSettings paddingBottom(int var1);

    public LayoutSettings paddingHorizontal(int var1);

    public LayoutSettings paddingVertical(int var1);

    public LayoutSettings align(float var1, float var2);

    public LayoutSettings alignHorizontally(float var1);

    public LayoutSettings alignVertically(float var1);

    default public LayoutSettings alignHorizontallyLeft() {
        return this.alignHorizontally(0.0f);
    }

    default public LayoutSettings alignHorizontallyCenter() {
        return this.alignHorizontally(0.5f);
    }

    default public LayoutSettings alignHorizontallyRight() {
        return this.alignHorizontally(1.0f);
    }

    default public LayoutSettings alignVerticallyTop() {
        return this.alignVertically(0.0f);
    }

    default public LayoutSettings alignVerticallyMiddle() {
        return this.alignVertically(0.5f);
    }

    default public LayoutSettings alignVerticallyBottom() {
        return this.alignVertically(1.0f);
    }

    public LayoutSettings copy();

    public LayoutSettingsImpl getExposed();

    public static LayoutSettings defaults() {
        return new LayoutSettingsImpl();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class LayoutSettingsImpl
    implements LayoutSettings {
        public int paddingLeft;
        public int paddingTop;
        public int paddingRight;
        public int paddingBottom;
        public float xAlignment;
        public float yAlignment;

        public LayoutSettingsImpl() {
        }

        public LayoutSettingsImpl(LayoutSettingsImpl pOther) {
            this.paddingLeft = pOther.paddingLeft;
            this.paddingTop = pOther.paddingTop;
            this.paddingRight = pOther.paddingRight;
            this.paddingBottom = pOther.paddingBottom;
            this.xAlignment = pOther.xAlignment;
            this.yAlignment = pOther.yAlignment;
        }

        @Override
        public LayoutSettingsImpl padding(int pPadding) {
            return this.padding(pPadding, pPadding);
        }

        @Override
        public LayoutSettingsImpl padding(int pHorizontalPadding, int pVerticalPadding) {
            return this.paddingHorizontal(pHorizontalPadding).paddingVertical(pVerticalPadding);
        }

        @Override
        public LayoutSettingsImpl padding(int pPaddingLeft, int pPaddingTop, int pPaddingRight, int pPaddingBottom) {
            return this.paddingLeft(pPaddingLeft).paddingRight(pPaddingRight).paddingTop(pPaddingTop).paddingBottom(pPaddingBottom);
        }

        @Override
        public LayoutSettingsImpl paddingLeft(int pPaddingLeft) {
            this.paddingLeft = pPaddingLeft;
            return this;
        }

        @Override
        public LayoutSettingsImpl paddingTop(int pPaddingTop) {
            this.paddingTop = pPaddingTop;
            return this;
        }

        @Override
        public LayoutSettingsImpl paddingRight(int pPaddingRight) {
            this.paddingRight = pPaddingRight;
            return this;
        }

        @Override
        public LayoutSettingsImpl paddingBottom(int pPaddingBottom) {
            this.paddingBottom = pPaddingBottom;
            return this;
        }

        @Override
        public LayoutSettingsImpl paddingHorizontal(int pPadding) {
            return this.paddingLeft(pPadding).paddingRight(pPadding);
        }

        @Override
        public LayoutSettingsImpl paddingVertical(int pPadding) {
            return this.paddingTop(pPadding).paddingBottom(pPadding);
        }

        @Override
        public LayoutSettingsImpl align(float pXAlignment, float pYAlignment) {
            this.xAlignment = pXAlignment;
            this.yAlignment = pYAlignment;
            return this;
        }

        @Override
        public LayoutSettingsImpl alignHorizontally(float pXAlignment) {
            this.xAlignment = pXAlignment;
            return this;
        }

        @Override
        public LayoutSettingsImpl alignVertically(float pYAlignment) {
            this.yAlignment = pYAlignment;
            return this;
        }

        @Override
        public LayoutSettingsImpl copy() {
            return new LayoutSettingsImpl(this);
        }

        @Override
        public LayoutSettingsImpl getExposed() {
            return this;
        }
    }
}

