/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.instrument.partial.note;

import com.cstav.genshinstrument.capability.instrumentOpen.InstrumentOpenProvider;
import com.cstav.genshinstrument.client.config.ModClientConfigs;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteButtonRenderer;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteNotation;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.label.NoteLabelSupplier;
import com.cstav.genshinstrument.client.util.ClientUtil;
import com.cstav.genshinstrument.networking.GIPacketHandler;
import com.cstav.genshinstrument.networking.buttonidentifier.NoteButtonIdentifier;
import com.cstav.genshinstrument.networking.packet.instrument.c2s.C2SNoteSoundPacket;
import com.cstav.genshinstrument.sound.NoteSound;
import com.cstav.genshinstrument.util.LabelUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import java.awt.Point;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public abstract class NoteButton
extends AbstractButton {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected final Minecraft minecraft = Minecraft.m_91087_();
    public final InstrumentScreen instrumentScreen;
    private NoteSound sound;
    private NoteLabelSupplier labelSupplier;
    protected NoteButtonRenderer noteRenderer;
    private int initX;
    private int initY;
    private int pitch;
    private boolean locked = false;

    @Nullable
    public NoteButtonIdentifier getIdentifier() {
        return null;
    }

    protected abstract NoteButtonRenderer initNoteRenderer();

    public NoteButton(NoteSound sound, NoteLabelSupplier labelSupplier, InstrumentScreen instrumentScreen, int pitch) {
        super(0, 0, 42, 42, (Component)Component.m_237119_());
        this.f_93618_ = this.f_93619_ = instrumentScreen.getNoteSize();
        this.sound = sound;
        this.labelSupplier = labelSupplier;
        this.instrumentScreen = instrumentScreen;
        this.pitch = pitch;
    }

    public NoteButton(NoteSound sound, NoteLabelSupplier labelSupplier, InstrumentScreen instrumentScreen) {
        this(sound, labelSupplier, instrumentScreen, instrumentScreen.getPitch());
    }

    public NoteButtonRenderer getRenderer() {
        return this.noteRenderer;
    }

    public void setLabelSupplier(NoteLabelSupplier labelSupplier) {
        this.labelSupplier = labelSupplier;
        this.updateNoteLabel();
    }

    public NoteLabelSupplier getLabelSupplier() {
        return this.labelSupplier;
    }

    public void updateNoteLabel() {
        this.m_93666_(this.getLabelSupplier().get(this));
    }

    public NoteSound getSound() {
        return this.sound;
    }

    public void setSound(NoteSound sound) {
        this.sound = sound;
    }

    public BlockPos getSoundSourcePos() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        return InstrumentOpenProvider.isItem((Player)player) ? player.m_20183_() : InstrumentOpenProvider.getBlockPos((Player)player);
    }

    public void initPos() {
        this.initX = this.f_93620_;
        this.initY = this.f_93621_;
        this.noteRenderer.setLabelX(this.f_93620_ + this.f_93618_ / 2);
        this.noteRenderer.setLabelY(this.f_93621_ + this.f_93619_ / 2 + 7);
    }

    public int getInitX() {
        return this.initX;
    }

    public int getInitY() {
        return this.initY;
    }

    public Point getCenter() {
        return ClientUtil.getInitCenter(this.initX, this.initY, this.instrumentScreen.getNoteSize(), this.f_93618_);
    }

    public void moveToCenter() {
        Point center = this.getCenter();
        this.f_93620_ = center.x;
        this.f_93621_ = center.y;
    }

    public int getPitch() {
        return this.pitch;
    }

    public void setPitch(int pitch) {
        this.pitch = NoteSound.clampPitch(pitch);
        this.updateNoteLabel();
    }

    public int soundIndex() {
        return this.getSound().index;
    }

    public NoteNotation getNotation() {
        return (Boolean)ModClientConfigs.ACCURATE_NOTES.get() != false ? NoteNotation.getNotation(this.getNoteName()) : NoteNotation.NONE;
    }

    public String getFormattedNoteName() {
        return LabelUtil.formatNoteName(this.getNoteName(), true);
    }

    public String getNoteName() {
        if (this.instrumentScreen.noteLayout() == null) {
            return "";
        }
        return LabelUtil.getNoteName(this.instrumentScreen.getPitch(), this.instrumentScreen.noteLayout(), this.getNoteOffset());
    }

    public abstract int getNoteOffset();

    public void init() {
        this.noteRenderer = this.initNoteRenderer();
        this.initPos();
        this.setLabelSupplier(this.labelSupplier);
    }

    public boolean isPlaying() {
        return this.noteRenderer.noteAnimation.isPlaying();
    }

    public void m_6303_(PoseStack stack, int mouseX, int mouseY, float partialTick) {
        this.noteRenderer.render(stack, mouseX, mouseY, partialTick, this.instrumentScreen.getThemeLoader());
    }

    public void release() {
        this.unlockInput();
    }

    public boolean isLocked() {
        return this.locked;
    }

    protected void lockInput() {
        this.locked = true;
    }

    public void unlockInput() {
        this.locked = false;
    }

    public boolean play(NoteSound sound, int pitch) {
        if (this.locked) {
            return false;
        }
        this.playLocalSound(sound, pitch);
        this.sendNotePlayPacket(sound, pitch);
        this.playNoteAnimation(false);
        this.lockInput();
        return true;
    }

    public boolean play() {
        return this.play(this.getSound(), this.getPitch());
    }

    public void m_5691_() {
        this.play();
    }

    protected void playLocalSound(NoteSound sound, int pitch) {
        sound.playLocally(pitch, this.instrumentScreen.volume(), this.getSoundSourcePos());
    }

    protected void sendNotePlayPacket(NoteSound sound, int pitch) {
        GIPacketHandler.sendToServer(new C2SNoteSoundPacket(this, sound, pitch));
    }

    public void playNoteAnimation(boolean isForeign) {
        if (this.instrumentScreen.instrumentRenders()) {
            this.noteRenderer.playNoteAnimation(isForeign);
        }
    }

    public int getABCOffset() {
        ResourceLocation instrumentId = this.instrumentScreen.getInstrumentId();
        String noteName = this.getNoteName();
        if (noteName.isEmpty()) {
            LOGGER.warn("Cannot get ABC offset for an instrument without a note layout! (" + instrumentId + ")");
            return 0;
        }
        char note = noteName.charAt(0);
        for (int i = 0; i < LabelUtil.ABC.length; ++i) {
            if (note != LabelUtil.ABC[i]) continue;
            return i;
        }
        LOGGER.warn("Could not get note " + note + " for instrument " + this.instrumentScreen.getInstrumentId() + "!");
        return 0;
    }

    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        this.m_93692_(false);
        return super.m_6348_(pMouseX, pMouseY, pButton);
    }

    public void m_7435_(SoundManager pHandler) {
    }

    public void m_142291_(NarrationElementOutput neo) {
        neo.m_169146_(NarratedElementType.TITLE, this.m_6035_());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof NoteButton)) return false;
        NoteButton btn = (NoteButton)((Object)obj);
        if (!this.getIdentifier().matches(btn)) return false;
        return true;
    }
}

