/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.instrument.partial.grid;

import com.cstav.genshinstrument.client.config.ModClientConfigs;
import com.cstav.genshinstrument.client.config.enumType.label.NoteGridLabel;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.grid.GridInstrumentMidiReceiver;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.grid.NoteGrid;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteButton;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.grid.NoteGridButton;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.label.NoteLabelSupplier;
import com.cstav.genshinstrument.client.gui.screen.options.instrument.GridInstrumentOptionsScreen;
import com.cstav.genshinstrument.client.gui.screen.options.instrument.partial.InstrumentOptionsScreen;
import com.cstav.genshinstrument.client.keyMaps.InstrumentKeyMappings;
import com.cstav.genshinstrument.client.midi.InstrumentMidiReceiver;
import com.cstav.genshinstrument.client.util.ClientUtil;
import com.cstav.genshinstrument.networking.buttonidentifier.NoteButtonIdentifier;
import com.cstav.genshinstrument.networking.buttonidentifier.NoteGridButtonIdentifier;
import com.cstav.genshinstrument.sound.NoteSound;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class GridInstrumentScreen
extends InstrumentScreen {
    public static final String[] NOTE_LAYOUT = new String[]{"C", "D", "E", "F", "G", "A", "B"};
    public static final int DEF_ROWS = 7;
    public static final int DEF_COLUMNS = 3;
    public static final int CLEF_WIDTH = 26;
    public static final int CLEF_HEIGHT = 52;
    protected AbstractWidget grid;
    public final NoteGrid noteGrid = this.initNoteGrid();
    private final Map<InputConstants.Key, NoteButton> noteMap = this.noteGrid.genKeyboardMap(InstrumentKeyMappings.GRID_INSTRUMENT_MAPPINGS);

    public int columns() {
        return 3;
    }

    public int rows() {
        return 7;
    }

    public abstract NoteSound[] getInitSounds();

    @Override
    public void setNoteSounds(NoteSound[] sounds) {
        this.noteGrid.setNoteSounds(sounds);
    }

    public boolean isSSTI() {
        return false;
    }

    @Override
    public void setPitch(int pitch) {
        if (!this.isSSTI()) {
            super.setPitch(pitch);
        }
    }

    @Override
    protected void initPitch(Consumer<Integer> pitchConsumer) {
        if (!this.isSSTI()) {
            super.initPitch(pitchConsumer);
        }
    }

    @Override
    protected boolean identifyByPitch() {
        return this.isSSTI();
    }

    @Override
    public NoteButton getNoteButton(NoteButtonIdentifier noteIdentifier) throws IndexOutOfBoundsException, NoSuchElementException {
        if (!(noteIdentifier instanceof NoteGridButtonIdentifier)) {
            return super.getNoteButton(noteIdentifier);
        }
        return this.getNoteButton((NoteGridButtonIdentifier)noteIdentifier);
    }

    public NoteButton getNoteButton(NoteGridButtonIdentifier noteIdentifier) throws IndexOutOfBoundsException {
        return this.getNoteButton(noteIdentifier.row, this.noteGrid.getFlippedColumn(noteIdentifier.column));
    }

    public NoteButton getNoteButton(int row, int column) throws IndexOutOfBoundsException {
        return this.noteGrid.getNoteButton(row, column);
    }

    public NoteButton getNoteButtonByMIDINote(int note) {
        return this.getNoteButton(note % this.rows(), note / this.rows());
    }

    public NoteGridButton createNote(int row, int column, int pitch) {
        return new NoteGridButton(row, column, this, pitch);
    }

    public NoteGridButton createNote(int row, int column) {
        return new NoteGridButton(row, column, this);
    }

    public static NoteLabelSupplier getInitLabelSupplier() {
        return ((NoteGridLabel)ModClientConfigs.GRID_LABEL_TYPE.get()).getLabelSupplier();
    }

    public NoteGrid initNoteGrid() {
        return this.isSSTI() ? new NoteGrid(this, NoteSound.MIN_PITCH) : new NoteGrid(this);
    }

    @Override
    public Map<InputConstants.Key, NoteButton> noteMap() {
        return this.noteMap;
    }

    @Override
    protected InstrumentOptionsScreen initInstrumentOptionsScreen() {
        return new GridInstrumentOptionsScreen(this);
    }

    @Override
    public String[] noteLayout() {
        return NOTE_LAYOUT;
    }

    @Override
    protected void m_7856_() {
        this.grid = this.noteGrid.initNoteGridWidget(0.9f, this.f_96543_, this.f_96544_);
        this.m_142416_((GuiEventListener)this.grid);
        this.initOptionsButton(this.grid.f_93621_ - 15);
        super.m_7856_();
    }

    @Override
    public void renderInstrument(PoseStack stack, int pMouseX, int pMouseY, float pPartialTick) {
        if (((Boolean)ModClientConfigs.RENDER_BACKGROUND.get()).booleanValue()) {
            this.renderInstrumentBackground(stack);
        }
        super.renderInstrument(stack, pMouseX, pMouseY, pPartialTick);
    }

    protected void renderInstrumentBackground(PoseStack stack) {
        int clefX = this.grid.f_93620_ - this.getNoteSize() + 8;
        if (this.columns() == 3) {
            this.renderClef(stack, 0, clefX, "treble");
            this.renderClef(stack, 1, clefX, "alto");
            this.renderClef(stack, 2, clefX, "bass");
        }
        for (int i = 0; i < this.columns(); ++i) {
            this.renderStaff(stack, i);
        }
    }

    protected void renderClef(PoseStack stack, int index, int x, String clefName) {
        ClientUtil.displaySprite(GridInstrumentScreen.getInternalResourceFromGlob("background/clef/" + clefName + ".png"));
        GridInstrumentScreen.m_93133_((PoseStack)stack, (int)x, (int)(this.grid.f_93621_ + NoteGrid.getPaddingVert() + this.getLayerAddition(index) - 5), (float)0.0f, (float)0.0f, (int)26, (int)52, (int)26, (int)52);
        RenderSystem.m_69461_();
    }

    protected void renderStaff(PoseStack stack, int index) {
        ClientUtil.displaySprite(GridInstrumentScreen.getInternalResourceFromGlob("background/staff.png"));
        GridInstrumentScreen.m_93133_((PoseStack)stack, (int)(this.grid.f_93620_ + 2), (int)(this.grid.f_93621_ + NoteGrid.getPaddingVert() + this.getLayerAddition(index)), (float)0.0f, (float)0.0f, (int)(this.grid.m_5711_() - 5), (int)this.getNoteSize(), (int)(this.grid.m_5711_() - 5), (int)this.getNoteSize());
        RenderSystem.m_69461_();
    }

    protected int getLayerAddition(int index) {
        return index * (this.getNoteSize() + NoteGrid.getPaddingVert() * 2);
    }

    @Override
    public InstrumentMidiReceiver initMidiReceiver() {
        return this.rows() != 7 || this.isSSTI() ? null : new GridInstrumentMidiReceiver(this);
    }
}

