/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.instrument.partial.grid;

import com.cstav.genshinstrument.client.gui.screen.instrument.partial.grid.GridInstrumentScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteButton;
import com.cstav.genshinstrument.client.midi.InstrumentMidiReceiver;
import com.cstav.genshinstrument.sound.NoteSound;
import org.jetbrains.annotations.Nullable;

public class GridInstrumentMidiReceiver
extends InstrumentMidiReceiver {
    public GridInstrumentMidiReceiver(GridInstrumentScreen instrument) {
        super(instrument);
    }

    protected GridInstrumentScreen gridInstrument() {
        return (GridInstrumentScreen)this.instrument;
    }

    @Override
    public boolean allowMidiOverflow() {
        return true;
    }

    @Override
    protected int maxMidiNote() {
        return NoteSound.MAX_PITCH * this.gridInstrument().columns();
    }

    @Override
    protected NoteButton getHighestNote() {
        return this.gridInstrument().getNoteButton(this.gridInstrument().rows() - 1, this.gridInstrument().columns() - 1);
    }

    @Override
    protected NoteButton getLowestNote() {
        return this.gridInstrument().getNoteButton(0, 0);
    }

    @Override
    @Nullable
    protected NoteButton handleMidiPress(int note, int key) {
        GridInstrumentScreen instrumentScreen = (GridInstrumentScreen)this.instrument;
        int layoutNote = note % 12;
        boolean higherThan3 = layoutNote > key + 4;
        boolean shouldSharpen = this.shouldSharpen(layoutNote, key);
        boolean shouldFlatten = this.shouldFlatten(shouldSharpen);
        this.transposeMidi(shouldSharpen, shouldFlatten);
        int playedNote = note + (shouldFlatten ? 1 : (shouldSharpen ? -1 : 0));
        playedNote = (playedNote + (higherThan3 ? 1 : 0)) / 2 + playedNote / (12 + key);
        return instrumentScreen.getNoteButtonByMIDINote(playedNote);
    }
}

