/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.instrument.partial;

import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentScreen;
import com.cstav.genshinstrument.util.CommonUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="genshinstrument", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class InstrumentThemeLoader {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String JSON_STYLER_NAME = "instrument_style.json";
    public static final ResourceLocation INSTRUMENTS_META_LOC = InstrumentScreen.getInternalResourceFromGlob("instruments.meta.json");
    public static final ResourceLocation GLOBAL_LOC = InstrumentScreen.getInternalResourceFromGlob("instrument/global");
    private static boolean isGlobalThemed;
    private static final HashMap<ResourceLocation, JsonObject> CACHES;
    private static final ArrayList<InstrumentThemeLoader> LOADERS;
    private static final Color DEF_PRESSED_THEME;
    public final ResourceLocation resourcesRootDir;
    public final ResourceLocation instrumentId;
    public final ResourceLocation subjectInstrumentId;
    private final boolean ignoreGlobal;
    private Color labelPressed = Color.BLACK;
    private Color labelReleased = Color.BLACK;
    private Color notePressed = Color.BLACK;
    private Color noteReleased = Color.BLACK;
    private Color noteRing = Color.BLACK;
    private final ArrayList<Consumer<JsonObject>> listeners = new ArrayList();

    public static boolean isGlobalThemed() {
        return isGlobalThemed;
    }

    public InstrumentThemeLoader(ResourceLocation resourceRootDir, ResourceLocation instrumentId, ResourceLocation subjectInstrumentId, boolean ignoreGlobal) {
        this.resourcesRootDir = resourceRootDir;
        this.instrumentId = instrumentId;
        this.subjectInstrumentId = subjectInstrumentId;
        this.ignoreGlobal = ignoreGlobal;
        LOADERS.add(this);
        this.addListener(this::loadColorTheme);
    }

    public InstrumentThemeLoader(ResourceLocation resourceRootDir, ResourceLocation instrumentId, boolean ignoreGlobal) {
        this(resourceRootDir, instrumentId, instrumentId, ignoreGlobal);
    }

    public InstrumentThemeLoader(ResourceLocation resourceRootDir, ResourceLocation instrumentId) {
        this(resourceRootDir, instrumentId, false);
    }

    public InstrumentThemeLoader(ResourceLocation instrumentId) {
        this(InstrumentScreen.getInstrumentRootPath(instrumentId), instrumentId);
    }

    public static InstrumentThemeLoader fromOther(InstrumentThemeLoader other, ResourceLocation instrumentId) {
        return new InstrumentThemeLoader(other.resourcesRootDir, instrumentId, other.subjectInstrumentId, other.ignoreGlobal);
    }

    public void addListener(Consumer<JsonObject> themeLoader) {
        this.listeners.add(themeLoader);
    }

    private void loadColorTheme(JsonObject theme) {
        if (!theme.has("label") || !theme.has("note")) {
            this.loadLegacyTheme(theme);
            return;
        }
        this.setPressStatedTheme(theme, "note", this::setNotePressed, this::setNoteReleased, DEF_PRESSED_THEME, Color.BLACK);
        this.setPressStatedTheme(theme, "label", this::setLabelPressed, this::setLabelReleased, this.notePressed(), Color.BLACK);
        this.setNoteRing(this.getTheme(theme, "note_ring", this.labelReleased()));
    }

    public void setPressStatedTheme(JsonObject theme, String propName, Consumer<Color> pressConsumer, Consumer<Color> releaseConsumer, Color defPress, Color defRelease) {
        JsonObject pressThemes = theme.getAsJsonObject(propName);
        if (pressThemes == null) {
            pressConsumer.accept(defPress);
            releaseConsumer.accept(defRelease);
            return;
        }
        pressConsumer.accept(this.getTheme(pressThemes, "pressed", defPress));
        releaseConsumer.accept(this.getTheme(pressThemes, "released", defRelease));
    }

    @Deprecated(forRemoval=true)
    private void loadLegacyTheme(JsonObject theme) {
        LOGGER.warn("The active resourcepack is using the legacy instrument styler format on instrument " + this.instrumentId + "!");
        LOGGER.warn("The format is deprecated and will be left unsupported, and should be migrated to the new format.");
        LOGGER.warn("Please update your pack, contact the author of it, or visit the Genshin Instruments GitHub repository to learn more.");
        this.setNoteTheme(this.getTheme(theme, "note_theme", Color.BLACK));
        this.setLabelTheme(this.getTheme(theme, "label_theme", Color.BLACK));
        this.setPressedNoteTheme(this.getTheme(theme, "note_pressed_theme", DEF_PRESSED_THEME));
        this.setNoteRingTheme(this.getTheme(theme, "note_ring_theme", this.getNoteTheme()));
        this.setLabelPressed(this.getPressedNoteTheme());
    }

    public Color getTheme(JsonObject theme, String propertyName, Color def) {
        JsonElement rgbArray = theme.get(propertyName);
        if (rgbArray == null || !rgbArray.isJsonArray()) {
            return def;
        }
        return this.tryGetProperty(rgbArray.getAsJsonArray(), rgb -> new Color(rgb.get(0).getAsInt(), rgb.get(1).getAsInt(), rgb.get(2).getAsInt()), def);
    }

    protected <T, J extends JsonElement> T tryGetProperty(J element, Function<J, T> getter, T def) {
        try {
            return getter.apply(element);
        }
        catch (Exception e) {
            LOGGER.error("Error retrieving JSON property for " + this.instrumentId, (Throwable)e);
            return def;
        }
    }

    @SubscribeEvent
    public static void registerReloadEvent(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)((ResourceManagerReloadListener)InstrumentThemeLoader::reload));
    }

    private static void reload(ResourceManager resourceManager) {
        InstrumentThemeLoader.updateIsGlobalThemed(resourceManager);
        for (InstrumentThemeLoader instrumentLoader : LOADERS) {
            instrumentLoader.performReload(resourceManager);
        }
        CACHES.clear();
    }

    private static void updateIsGlobalThemed(ResourceManager resourceManager) {
        isGlobalThemed = false;
        Optional instrumentsMeta = resourceManager.m_213713_(INSTRUMENTS_META_LOC);
        if (instrumentsMeta.isEmpty()) {
            LOGGER.warn("No instrument meta found for " + INSTRUMENTS_META_LOC + "!");
            return;
        }
        try (BufferedReader reader = ((Resource)instrumentsMeta.get()).m_215508_();){
            isGlobalThemed = JsonParser.parseReader((Reader)reader).getAsJsonObject().get("is_global_pack").getAsBoolean();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (isGlobalThemed) {
            LOGGER.info("Instrument global themes enabled; loading all instrument resources from " + GLOBAL_LOC);
        }
    }

    private void performReload(ResourceManager resourceManager) {
        String logSuffix = " for " + this.instrumentId;
        ResourceLocation styleLocation = this.getStylerLocation();
        try {
            if (CACHES.containsKey(styleLocation)) {
                JsonObject styleInfo = CACHES.get(styleLocation);
                for (Consumer<JsonObject> listener : this.listeners) {
                    listener.accept(styleInfo);
                }
                LOGGER.info("Loaded instrument style from already cached " + styleLocation + logSuffix);
                return;
            }
        }
        catch (Exception e) {
            LOGGER.error("Met an exception upon loading the instrument styler from " + styleLocation + logSuffix, (Throwable)e);
        }
        Optional styler = resourceManager.m_213713_(styleLocation);
        if (styler.isEmpty()) {
            LOGGER.error("Could not retrieve styler information from " + styleLocation + "!");
            return;
        }
        try (BufferedReader reader = ((Resource)styler.get()).m_215508_();){
            JsonObject styleInfo = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            for (Consumer<JsonObject> listener : this.listeners) {
                listener.accept(styleInfo);
            }
            CACHES.put(styleLocation, styleInfo);
        }
        catch (Exception e) {
            LOGGER.error("Met an exception upon loading the instrument styler from " + styleLocation + logSuffix, (Throwable)e);
        }
        LOGGER.info("Loaded and cached instrument style from " + styleLocation + logSuffix);
    }

    public ResourceLocation getResourcesRootDir() {
        return this.resourcesRootDir;
    }

    public ResourceLocation getStylerLocation() {
        return CommonUtil.withSuffix(!this.ignoreGlobal && isGlobalThemed ? GLOBAL_LOC : this.getResourcesRootDir(), "/instrument_style.json");
    }

    public Color labelPressed() {
        return this.labelPressed;
    }

    public void setLabelPressed(Color labelPressed) {
        this.labelPressed = labelPressed;
    }

    public Color labelReleased() {
        return this.labelReleased;
    }

    public void setLabelReleased(Color labelReleased) {
        this.labelReleased = labelReleased;
    }

    public Color notePressed() {
        return this.notePressed;
    }

    public void setNotePressed(Color notePressed) {
        this.notePressed = notePressed;
    }

    public Color noteReleased() {
        return this.noteReleased;
    }

    public void setNoteReleased(Color noteReleased) {
        this.noteReleased = noteReleased;
    }

    public Color noteRing() {
        return this.noteRing;
    }

    public void setNoteRing(Color noteRingTheme) {
        this.noteRing = noteRingTheme;
    }

    @Deprecated(forRemoval=true)
    public Color getNoteTheme() {
        return this.getColorTheme(this.labelReleased);
    }

    @Deprecated(forRemoval=true)
    public void setNoteTheme(Color noteTheme) {
        this.labelReleased = noteTheme;
    }

    @Deprecated(forRemoval=true)
    public Color getPressedNoteTheme() {
        return this.getColorTheme(this.notePressed);
    }

    @Deprecated(forRemoval=true)
    public void setPressedNoteTheme(Color pressedNoteTheme) {
        this.notePressed = pressedNoteTheme;
    }

    @Deprecated(forRemoval=true)
    public Color getLabelTheme() {
        return this.getColorTheme(this.noteReleased);
    }

    @Deprecated(forRemoval=true)
    public void setLabelTheme(Color labelTheme) {
        this.noteReleased = labelTheme;
    }

    @Deprecated(forRemoval=true)
    public Color getNoteRingTheme() {
        return this.getColorTheme(this.noteRing);
    }

    @Deprecated(forRemoval=true)
    public void setNoteRingTheme(Color noteRingTheme) {
        this.noteRing = noteRingTheme;
    }

    @Deprecated(forRemoval=true)
    protected Color getColorTheme(Color theme) {
        return this.getTheme(theme, Color.BLACK);
    }

    @Deprecated(forRemoval=true)
    protected <T> T getTheme(T theme, T def) {
        return theme == null ? def : theme;
    }

    static {
        CACHES = new HashMap();
        LOADERS = new ArrayList();
        DEF_PRESSED_THEME = new Color(255, 249, 239);
    }
}

