/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.instrument.partial;

import com.cstav.genshinstrument.capability.instrumentOpen.InstrumentOpenProvider;
import com.cstav.genshinstrument.client.config.ModClientConfigs;
import com.cstav.genshinstrument.client.gui.screen.instrument.GenshinConsentScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentThemeLoader;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteButton;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.label.NoteLabelSupplier;
import com.cstav.genshinstrument.client.gui.screen.options.instrument.partial.AbstractInstrumentOptionsScreen;
import com.cstav.genshinstrument.client.gui.screen.options.instrument.partial.InstrumentOptionsScreen;
import com.cstav.genshinstrument.client.gui.widget.IconToggleButton;
import com.cstav.genshinstrument.client.gui.widget.copied.AbstractContainerWidget;
import com.cstav.genshinstrument.client.keyMaps.InstrumentKeyMappings;
import com.cstav.genshinstrument.client.midi.InstrumentMidiReceiver;
import com.cstav.genshinstrument.event.InstrumentPlayedEvent;
import com.cstav.genshinstrument.event.NoteSoundPlayedEvent;
import com.cstav.genshinstrument.networking.GIPacketHandler;
import com.cstav.genshinstrument.networking.buttonidentifier.NoteButtonIdentifier;
import com.cstav.genshinstrument.networking.packet.instrument.c2s.CloseInstrumentPacket;
import com.cstav.genshinstrument.sound.NoteSound;
import com.cstav.genshinstrument.util.CommonUtil;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class InstrumentScreen
extends Screen {
    private static final int VISIBILITY_BUTTON_MARGIN = 6;
    private static final String VISIBILITY_SPRITE_LOC = "textures/gui/sprites/icon/visibility/";
    private int pitch;
    public int volume = (int)((Double)ModClientConfigs.VOLUME.get() * 100.0);
    private NoteLabelSupplier noteLabelSupplier;
    public final InstrumentMidiReceiver midiReceiver;
    public final InstrumentOptionsScreen optionsScreen = this.initInstrumentOptionsScreen();
    protected IconToggleButton visibilityButton;
    private boolean pitchChanged;
    private boolean isOptionsScreenActive;
    private boolean closed = false;

    public int getNoteSize() {
        return switch ((Integer)Minecraft.m_91087_().f_91066_.m_231928_().m_231551_()) {
            case 1 -> 36;
            case 2 -> 46;
            case 3 -> 48;
            case 4 -> 40;
            case 5 -> 35;
            case 6 -> 30;
            default -> 35;
        };
    }

    public int getPitch() {
        return this.pitch;
    }

    public void setPitch(int pitch) {
        this.pitch = NoteSound.clampPitch(pitch);
        this.notesIterable().forEach(note -> note.setPitch(this.pitch));
    }

    protected void initPitch(Consumer<Integer> pitchConsumer) {
        pitchConsumer.accept((Integer)ModClientConfigs.PITCH.get());
    }

    public void resetPitch() {
        this.initPitch(this::setPitch);
    }

    public float volume() {
        return (float)this.volume / 100.0f;
    }

    public void setVolume(float volume) {
        this.volume = (int)(volume * 100.0f);
    }

    public void setNoteSounds(NoteSound[] sounds) {
        Iterator<NoteButton> noteIterator = this.notesIterable().iterator();
        int i = 0;
        while (noteIterator.hasNext() && i < sounds.length) {
            noteIterator.next().setSound(sounds[i++]);
        }
        if (noteIterator.hasNext() || i < sounds.length) {
            LogUtils.getLogger().warn("Not all sounds were set for instrument " + this.getInstrumentId() + "!");
        }
    }

    public void setLabelSupplier(NoteLabelSupplier supplier) {
        this.noteLabelSupplier = supplier;
        this.notesIterable().forEach(note -> note.setLabelSupplier(supplier));
    }

    public NoteLabelSupplier getNoteLabelSupplier() {
        return this.noteLabelSupplier;
    }

    public abstract InstrumentThemeLoader getThemeLoader();

    public abstract ResourceLocation getInstrumentId();

    protected abstract InstrumentOptionsScreen initInstrumentOptionsScreen();

    public String[] noteLayout() {
        return null;
    }

    public boolean isGenshinInstrument() {
        return true;
    }

    public InstrumentMidiReceiver initMidiReceiver() {
        return null;
    }

    public boolean isMidiInstrument() {
        return this.midiReceiver != null;
    }

    public void handleAbruptClosing() {
        if (!InstrumentOpenProvider.isOpen((Player)this.f_96541_.f_91074_)) {
            this.onClose(false);
        }
    }

    public NoteButton getNoteButton(Optional<NoteButtonIdentifier> noteIdentifier, NoteSound noteSound, int pitch) throws NoSuchElementException {
        if (noteIdentifier.isEmpty()) {
            return this.getNoteButton(noteSound, pitch);
        }
        return this.getNoteButton(noteIdentifier.get());
    }

    public NoteButton getNoteButton(NoteButtonIdentifier noteIdentifier) {
        for (NoteButton note : this.notesIterable()) {
            if (!noteIdentifier.matches(note)) continue;
            return note;
        }
        throw new NoSuchElementException("Could not find a note in " + this.getInstrumentId() + " based on the given identifier");
    }

    public NoteButton getNoteButton(NoteSound noteSound, int pitch) {
        for (NoteButton note : this.notesIterable()) {
            NoteSound sound = note.getSound();
            if (!noteSound.equals(sound) || this.identifyByPitch() && note.getPitch() != pitch) continue;
            return note;
        }
        throw new NoSuchElementException("Could not find a note in " + this.getInstrumentId() + " based on the given identifier");
    }

    protected boolean identifyByPitch() {
        return false;
    }

    public abstract Map<InputConstants.Key, NoteButton> noteMap();

    public Iterable<NoteButton> notesIterable() {
        return this.noteMap().values();
    }

    public static String getGlobalRootPath() {
        return "textures/gui/genshinstrument/";
    }

    public ResourceLocation getResourceFromGlob(String path) {
        return CommonUtil.withPath(this.getSourcePath(), InstrumentScreen.getGlobalRootPath() + "instrument/" + path);
    }

    public static ResourceLocation getInternalResourceFromGlob(String path) {
        return new ResourceLocation("genshinstrument", InstrumentScreen.getGlobalRootPath() + path);
    }

    public static ResourceLocation getInstrumentRootPath(ResourceLocation instrumentId) {
        return CommonUtil.withPath(instrumentId, InstrumentScreen.getGlobalRootPath() + "instrument/" + instrumentId.m_135815_());
    }

    protected String getPath() {
        return InstrumentScreen.getGlobalRootPath() + "instrument/" + this.getSourcePath().m_135815_() + "/";
    }

    public ResourceLocation getSourcePath() {
        return this.getThemeLoader().subjectInstrumentId;
    }

    public String getModId() {
        return this.getInstrumentId().m_135827_();
    }

    public ResourceLocation getResourceFromRoot(String path, boolean considerGlobal) {
        return considerGlobal && InstrumentThemeLoader.isGlobalThemed() ? CommonUtil.withSuffix(InstrumentThemeLoader.GLOBAL_LOC, "/" + path) : CommonUtil.withPath(this.getSourcePath(), this.getPath() + path);
    }

    public ResourceLocation getResourceFromRoot(String path) {
        return this.getResourceFromRoot(path, true);
    }

    public InstrumentScreen() {
        super(CommonComponents.f_237098_);
        this.midiReceiver = this.initMidiReceiver();
    }

    protected void m_7856_() {
        this.resetPitch();
        this.optionsScreen.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
        boolean wasEnabled = false;
        if (this.visibilityButton != null) {
            wasEnabled = this.visibilityButton.enabled();
        }
        this.visibilityButton = this.initVisibilityButton();
        this.m_142416_((GuiEventListener)this.visibilityButton);
        this.visibilityButton.setEnabled(wasEnabled);
        if (this.isGenshinInstrument() && !((Boolean)ModClientConfigs.ACCEPTED_GENSHIN_CONSENT.get()).booleanValue()) {
            this.f_96541_.m_91152_((Screen)new GenshinConsentScreen(this));
        }
    }

    protected AbstractWidget initOptionsButton(int vertOffset) {
        Button button = new Button(0, 0, 150, 20, (Component)Component.m_237115_((String)"button.genshinstrument.instrumentOptions").m_130946_("..."), btn -> this.onOptionsOpen());
        button.f_93620_ = (this.f_96543_ - button.m_5711_()) / 2;
        button.f_93621_ = vertOffset - button.m_93694_() / 2;
        this.m_142416_((GuiEventListener)button);
        return button;
    }

    protected IconToggleButton initVisibilityButton() {
        return new IconToggleButton(6, 6, new ResourceLocation("genshinstrument", "textures/gui/sprites/icon/visibility/enabled.png"), new ResourceLocation("genshinstrument", "textures/gui/sprites/icon/visibility/disabled.png"), btn -> this.onInstrumentRenderStateChanged(this.instrumentRenders()));
    }

    public void foreignPlay(InstrumentPlayedEvent<?> event) {
        if (!(event instanceof NoteSoundPlayedEvent)) {
            return;
        }
        NoteSoundPlayedEvent e = (NoteSoundPlayedEvent)event;
        try {
            this.getNoteButton(event.soundMeta().noteIdentifier(), (NoteSound)e.sound(), event.soundMeta().pitch()).playNoteAnimation(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean instrumentRenders() {
        return !this.visibilityButton.enabled();
    }

    protected void onInstrumentRenderStateChanged(boolean isVisible) {
        if (!isVisible) {
            this.notesIterable().forEach(note -> note.getRenderer().resetAnimations());
        }
        this.m_6702_().forEach(renderable -> InstrumentScreen.setActive(renderable, isVisible));
        this.visibilityButton.f_93623_ = true;
    }

    private static void setActive(GuiEventListener renderable, boolean isActive) {
        if (renderable instanceof AbstractWidget) {
            AbstractWidget widget = (AbstractWidget)renderable;
            widget.f_93623_ = isActive;
        }
        if (renderable instanceof AbstractContainerWidget) {
            AbstractContainerWidget container = (AbstractContainerWidget)renderable;
            container.m_6702_().forEach(innerRenderable -> InstrumentScreen.setActive(innerRenderable, isActive));
        }
    }

    public void m_6305_(PoseStack stack, int pMouseX, int pMouseY, float pPartialTick) {
        if (!this.instrumentRenders()) {
            this.visibilityButton.m_6305_(stack, pMouseX, pMouseY, pPartialTick);
            return;
        }
        this.renderInstrument(stack, pMouseX, pMouseY, pPartialTick);
    }

    public void renderInstrument(PoseStack pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.m_6305_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.checkPitchTransposeUp(pKeyCode, pScanCode)) {
            return true;
        }
        NoteButton note = this.getNoteByKey(pKeyCode);
        if (note != null) {
            note.play();
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public boolean m_7920_(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.checkTransposeDown(pKeyCode, pScanCode)) {
            return true;
        }
        if (pKeyCode == 257 && pScanCode == 36) {
            this.unlockFocused();
        } else {
            if (!this.isKeyConsumed(pKeyCode, pScanCode)) {
                return false;
            }
            NoteButton note = this.getNoteByKey(pKeyCode);
            if (note != null) {
                note.release();
            }
        }
        return super.m_7920_(pKeyCode, pScanCode, pModifiers);
    }

    protected boolean checkPitchTransposeUp(int pKeyCode, int pScanCode) {
        if (this.pitchChanged) {
            return false;
        }
        if (this.checkTransposeUpKey(pKeyCode, pScanCode)) {
            this.transposeUp();
            return true;
        }
        if (this.checkTransposeDownKey(pKeyCode, pScanCode)) {
            this.transposeDown();
            return true;
        }
        return false;
    }

    protected boolean checkTransposeDown(int pKeyCode, int pScanCode) {
        if (!this.pitchChanged) {
            return false;
        }
        if (this.checkTransposeUpKey(pKeyCode, pScanCode) || this.checkTransposeDownKey(pKeyCode, pScanCode)) {
            this.resetTransposition();
            return true;
        }
        return false;
    }

    public void transposeUp() {
        this.setPitch(this.getPitch() + 1);
        this.pitchChanged = true;
    }

    public void transposeDown() {
        this.setPitch(this.getPitch() - 1);
        this.pitchChanged = true;
    }

    public void resetTransposition() {
        this.resetPitch();
        this.pitchChanged = false;
    }

    public boolean isTransposed() {
        return this.pitchChanged;
    }

    public boolean isKeyConsumed(int keyCode, int scanCode) {
        return this.getNoteByKey(keyCode) != null || this.checkTransposeDownKey(keyCode, scanCode) || this.checkTransposeUpKey(keyCode, scanCode);
    }

    protected boolean checkTransposeDownKey(int keyCode, int scanCode) {
        return ((KeyMapping)InstrumentKeyMappings.TRANSPOSE_DOWN_MODIFIER.get()).m_90832_(keyCode, scanCode);
    }

    protected boolean checkTransposeUpKey(int keyCode, int scanCode) {
        return ((KeyMapping)InstrumentKeyMappings.TRANSPOSE_UP_MODIFIER.get()).m_90832_(keyCode, scanCode);
    }

    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        this.unlockFocused();
        return super.m_6348_(pMouseX, pMouseY, pButton);
    }

    public NoteButton getNoteByKey(int keyCode) {
        InputConstants.Key key = InputConstants.Type.KEYSYM.m_84895_(keyCode);
        return this.noteMap().getOrDefault(key, null);
    }

    private void unlockFocused() {
        for (NoteButton note : this.notesIterable()) {
            if (!note.isLocked()) continue;
            note.release();
        }
    }

    public boolean isOptionsScreenActive() {
        return this.isOptionsScreenActive;
    }

    public void onOptionsOpen() {
        this.m_7522_(null);
        this.f_96541_.pushGuiLayer((Screen)this.optionsScreen);
        this.resetPitch();
        this.isOptionsScreenActive = true;
    }

    public void onOptionsClose() {
        this.isOptionsScreenActive = false;
    }

    public final void m_7379_() {
        this.onClose(true);
    }

    public void onClose(boolean notify) {
        if (!this.closed) {
            if (notify) {
                this.notifyClosed();
            }
            if (this.isOptionsScreenActive) {
                this.optionsScreen.m_7379_();
            }
            this.closed = true;
        }
        super.m_7379_();
    }

    public void m_7861_() {
        if (!this.closed) {
            this.notifyClosed();
            if (this.isOptionsScreenActive) {
                this.optionsScreen.saveOptions();
            }
            this.closed = true;
        }
        super.m_7861_();
    }

    private void notifyClosed() {
        InstrumentOpenProvider.setClosed((Player)this.f_96541_.f_91074_);
        GIPacketHandler.sendToServer(new CloseInstrumentPacket());
    }

    public static Optional<InstrumentScreen> getCurrentScreen(Minecraft minecraft) {
        if (minecraft.f_91080_ instanceof InstrumentScreen) {
            return Optional.of((InstrumentScreen)minecraft.f_91080_);
        }
        Screen screen = minecraft.f_91080_;
        if (screen instanceof AbstractInstrumentOptionsScreen) {
            AbstractInstrumentOptionsScreen instrumentOptionsScreen = (AbstractInstrumentOptionsScreen)screen;
            return instrumentOptionsScreen.instrumentScreen;
        }
        return Optional.empty();
    }

    public static Optional<InstrumentScreen> getCurrentScreen() {
        return InstrumentScreen.getCurrentScreen(Minecraft.m_91087_());
    }

    public boolean m_7043_() {
        return false;
    }
}

