/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.station;

import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.graph.DimensionPalette;
import com.simibubi.create.content.trains.graph.TrackNode;
import com.simibubi.create.content.trains.signal.SingleBlockEntityEdgePoint;
import com.simibubi.create.content.trains.station.StationBlock;
import java.lang.ref.WeakReference;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class GlobalStation
extends SingleBlockEntityEdgePoint {
    public String name = "Track Station";
    public WeakReference<Train> nearestTrain = new WeakReference<Object>(null);
    public boolean assembling;

    @Override
    public void blockEntityAdded(BlockEntity blockEntity, boolean front) {
        super.blockEntityAdded(blockEntity, front);
        BlockState state = blockEntity.m_58900_();
        this.assembling = state != null && state.m_61138_((Property)StationBlock.ASSEMBLING) && (Boolean)state.m_61143_((Property)StationBlock.ASSEMBLING) != false;
    }

    @Override
    public void read(CompoundTag nbt, boolean migration, DimensionPalette dimensions) {
        super.read(nbt, migration, dimensions);
        this.name = nbt.m_128461_("Name");
        this.assembling = nbt.m_128471_("Assembling");
        this.nearestTrain = new WeakReference<Object>(null);
    }

    @Override
    public void read(FriendlyByteBuf buffer, DimensionPalette dimensions) {
        super.read(buffer, dimensions);
        this.name = buffer.m_130277_();
        this.assembling = buffer.readBoolean();
        if (buffer.readBoolean()) {
            this.blockEntityPos = buffer.m_130135_();
        }
    }

    @Override
    public void write(CompoundTag nbt, DimensionPalette dimensions) {
        super.write(nbt, dimensions);
        nbt.m_128359_("Name", this.name);
        nbt.m_128379_("Assembling", this.assembling);
    }

    @Override
    public void write(FriendlyByteBuf buffer, DimensionPalette dimensions) {
        super.write(buffer, dimensions);
        buffer.m_130070_(this.name);
        buffer.writeBoolean(this.assembling);
        buffer.writeBoolean(this.blockEntityPos != null);
        if (this.blockEntityPos != null) {
            buffer.m_130064_(this.blockEntityPos);
        }
    }

    public boolean canApproachFrom(TrackNode side) {
        return this.isPrimary(side) && !this.assembling;
    }

    @Override
    public boolean canNavigateVia(TrackNode side) {
        return super.canNavigateVia(side) && !this.assembling;
    }

    public void reserveFor(Train train) {
        Train nearestTrain = this.getNearestTrain();
        if (nearestTrain == null || nearestTrain.navigation.distanceToDestination > train.navigation.distanceToDestination) {
            this.nearestTrain = new WeakReference<Train>(train);
        }
    }

    public void cancelReservation(Train train) {
        if (this.nearestTrain.get() == train) {
            this.nearestTrain = new WeakReference<Object>(null);
        }
    }

    public void trainDeparted(Train train) {
        this.cancelReservation(train);
    }

    @Nullable
    public Train getPresentTrain() {
        Train nearestTrain = this.getNearestTrain();
        if (nearestTrain == null || nearestTrain.getCurrentStation() != this) {
            return null;
        }
        return nearestTrain;
    }

    @Nullable
    public Train getImminentTrain() {
        Train nearestTrain = this.getNearestTrain();
        if (nearestTrain == null) {
            return nearestTrain;
        }
        if (nearestTrain.getCurrentStation() == this) {
            return nearestTrain;
        }
        if (!nearestTrain.navigation.isActive()) {
            return null;
        }
        if (nearestTrain.navigation.distanceToDestination > 30.0) {
            return null;
        }
        return nearestTrain;
    }

    @Nullable
    public Train getNearestTrain() {
        return (Train)this.nearestTrain.get();
    }
}

