/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.crate;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.logistics.crate.BottomlessItemHandler;
import com.simibubi.create.content.logistics.crate.CrateBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class CreativeCrateBlockEntity
extends CrateBlockEntity {
    FilteringBehaviour filtering;
    LazyOptional<IItemHandler> itemHandler;
    private BottomlessItemHandler inv = new BottomlessItemHandler(this.filtering::getFilter);

    public CreativeCrateBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.itemHandler = LazyOptional.of(() -> this.inv);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.filtering = this.createFilter();
        behaviours.add(this.filtering);
        this.filtering.setLabel(Lang.translateDirect("logistics.creative_crate.supply", new Object[0]));
    }

    @Override
    public void invalidate() {
        super.invalidate();
        if (this.itemHandler != null) {
            this.itemHandler.invalidate();
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public FilteringBehaviour createFilter() {
        return new FilteringBehaviour(this, new ValueBoxTransform(){

            @Override
            public void rotate(BlockState state, PoseStack ms) {
                TransformStack.cast((PoseStack)ms).rotateX(90.0);
            }

            @Override
            public Vec3 getLocalOffset(BlockState state) {
                return new Vec3(0.5, 0.84375, 0.5);
            }

            @Override
            public float getScale() {
                return super.getScale();
            }
        });
    }
}

